﻿using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.Mvc.Filters;
using Microsoft.Extensions.Logging;
using Performance.DtoModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api
{
    public class ExceptionsFilter : IAsyncExceptionFilter
    {
        private readonly ILogger<ExceptionsFilter> _logger;

        public ExceptionsFilter(ILogger<ExceptionsFilter> logger)
        {
            this._logger = logger;
        }

        public Task OnExceptionAsync(ExceptionContext context)
        {
            if (context.Exception is PerformanceException)
            {
                _logger.LogWarning($"接口错误警告:{context.Exception.ToString()}");
                context.Result = new ObjectResult(new ApiResponse(ResponseType.Fail, context.Exception.Message));
            }
            else
            {
                _logger.LogError($"接口异常:{context.Exception.ToString()}");
                var response = new ApiResponse(ResponseType.Error, "接口内部异常", context.Exception.Message);
                context.Result = new ObjectResult(response);
            }
            return Task.CompletedTask;
        }
    }
}
