﻿using Microsoft.Extensions.Caching.Memory;
using Performance.DtoModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Performance.Api
{
    public class ClaimService
    {
        IMemoryCache _memoryCache;
        public ClaimService(IMemoryCache memoryCache)
        {
            _memoryCache = memoryCache;
        }

        public UserIdentity At(ApiRequest request)
        {
            return At(request.Token);
        }

        public UserIdentity At(string token)
        {
            if (string.IsNullOrEmpty(token))
                throw new PerformanceException("token is not null");
            var user = _memoryCache.Get<UserIdentity>(token);
            if (user == null)
                throw new PerformanceException("当前用户未登录");
            return user;
        }
    }
}
