﻿using AutoMapper;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Performance.DtoModels;
using Performance.DtoModels.AppSettings;
using Performance.DtoModels.AutoMapper;
using Performance.EntityModels;
using Performance.Infrastructure;
using Performance.Repository;
using Performance.Services;
using System;
using System.Collections.Generic;
using System.IO;

namespace Performance.ConsoleApp
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine($"{(21555 / 1000.0).ToString("f2")}");


            Console.WriteLine("Hello World!");

            var builder = new ConfigurationBuilder()
                  .SetBasePath(AppDomain.CurrentDomain.BaseDirectory)
                  .AddJsonFile("appsettings.json", optional: true, reloadOnChange: true)
                  .AddJsonFile("appsettings.Development.json", optional: true, reloadOnChange: true);
            IConfigurationRoot configuration = builder.Build();

            ServiceCollection services = new ServiceCollection();

            Mapper.Initialize(cfg => cfg.AddProfile<AutoMapperConfigs>());
            services.AddAutoMapper();

            //service注入 repoitory注入 
            services
                .AddPerformanceService()
                .AddPerformanceRepoitory();

            var connection = configuration.GetSection("AppConnection:PerformanceConnectionString").Value;

            services.AddDbContext<PerformanceDbContext>(options =>
            {
                options.UseMySQL(connection);
            });

            //PerHeaderService perHeaderService = new PerHeaderService();
            //PerSheetService perSheetService = new PerSheetService(perHeaderService);
            //PerExcelService perExcelService = new PerExcelService(perSheetService, perHeaderService);
            //var excel = perExcelService.Import(@"E:\code_git\performance\performance\Performance.Api\Files\9\201911\医院绩效分配系统数据收集模板V120190307133444707.xlsx");

            PerExcelService perExcelService = services.BuildServiceProvider().GetService<PerExcelService>();

            // 拷贝配置信息
            //perExcelService.Copy(allot.ID);

            string path = @"E:\code_git\performance\performance\Performance.Api\Files\9\201911\医院绩效分配系统数据收集模板V120190307133444707.xlsx";
            // 导出数据
            var excel = perExcelService.Import(path);

            var workbook1 = perExcelService.ExportCompute(excel.PerSheet);

            using (FileStream file = new FileStream($@"F:\myworkbook\org_{DateTime.Now.ToString("yyyyMMddhhmmss")}.xlsx", FileMode.Create))
            {
                workbook1.Write(file);
            }

            // 保存数据
            perExcelService.Save(excel.PerSheet, 2, 1);

            // 计算合并数据
            List<PerSheet> list = perExcelService.ProcessCompute(excel);

            // 保存过程数据
            perExcelService.Save(list, 2, 2);

            // 生成结果excel
            var workbook2 = perExcelService.ExportCompute(list);

            using (FileStream file = new FileStream($@"F:\myworkbook\comp_{DateTime.Now.ToString("yyyyMMddhhmmss")}.xlsx", FileMode.Create))
            {
                workbook2.Write(file);
            }

            // 计算最总数据
            perExcelService.Compute(excel);

            Console.ReadKey();
        }
    }
}
