﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class SheetExportResponse
    {
        /// <summary>
        /// sheetID
        /// </summary>
        public int SheetID { get; set; }
        /// <summary>
        /// sheet名称
        /// </summary>
        public string SheetName { get; set; }
        /// <summary>
        /// sheet模板类型
        /// </summary>
        public int SheetType { get; set; }

        /// <summary>
        /// sheet头
        /// </summary>
        public List<Row> Header { get; set; }

        /// <summary>
        /// sheet数据
        /// </summary>
        public List<Row> Row { get; set; }

        public SheetExportResponse() { }

        public SheetExportResponse(int sheetID, string sheetName, int sheetType)
        {
            SheetID = sheetID;
            SheetName = sheetName;
            SheetType = sheetType;
            Header = new List<Row>();
            Row = new List<Row>();
        }
    }

    public class Row
    {
        public int Rownumber { get; set; }
        public List<Cell> Data { get; set; }

        public Row() { }
        public Row(int rownumber)
        {
            Rownumber = rownumber;
            Data = new List<Cell>();
        }
    }

    public class Cell
    {
        public int PointCell { get; set; }
        public object CellValue { get; set; }
        public int MergeRow { get; set; }
        public int MergeCell { get; set; }
        public bool IsTotal { get; set; }
        public bool IsNumValue { get; set; }
        /// <summary>
        /// 单元格注释
        /// </summary>
        public string Annotation { get; set; }

        public Cell() { }
        public Cell(int pointCell, object cellValue, int mergeRow, int mergeCell, bool isTotal, bool isNumValue, string annotation = "")
        {
            PointCell = pointCell;
            CellValue = cellValue;
            MergeRow = mergeRow;
            MergeCell = mergeCell;
            IsTotal = isTotal;
            IsNumValue = isNumValue;
            Annotation = annotation;
        }
    }
}
