//-----------------------------------------------------------------------
// <copyright file=" im_accountnurse.cs">
// * FileName: im_accountnurse.cs
// * history : 2019-03-20 09:47:33 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;

namespace Performance.EntityModels	
{
    /// <summary>
    /// im_accountnurse Entity Model
    /// </summary>
    public class im_accountnurse
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
		public int ID { get; set; }
    
        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> SheetID { get; set; }
    
        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
    
        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }
    
        /// <summary>
        /// 护士人数
        /// </summary>
        public Nullable<decimal> Number { get; set; }
    
        /// <summary>
        /// 护理基础系数
        /// </summary>
        public Nullable<decimal> BasicFactor { get; set; }
    
        /// <summary>
        /// 倾斜系数
        /// </summary>
        public Nullable<decimal> SlopeFactor { get; set; }
    
        /// <summary>
        /// 其他绩效1
        /// </summary>
        public Nullable<decimal> OtherPerfor1 { get; set; }
    
        /// <summary>
        /// 其他绩效2
        /// </summary>
        public Nullable<decimal> OtherPerfor2 { get; set; }
    
        /// <summary>
        /// 医院奖罚
        /// </summary>
        public Nullable<decimal> Extra { get; set; }
    
        /// <summary>
        /// 考核对分率
        /// </summary>
        public Nullable<decimal> ScoringAverage { get; set; }
    
        /// <summary>
        /// 调节系数
        /// </summary>
        public Nullable<decimal> AdjustFactor { get; set; }
    
        /// <summary>
        /// 科室业绩
        /// </summary>
        public Nullable<decimal> Income { get; set; }
    
        /// <summary>
        /// 业绩绩效
        /// </summary>
        public Nullable<decimal> PerforFee { get; set; }
    
        /// <summary>
        /// 工作量绩效
        /// </summary>
        public Nullable<decimal> WorkloadFee { get; set; }
    
        /// <summary>
        /// 绩效合计
        /// </summary>
        public Nullable<decimal> PerforTotal { get; set; }
    
        /// <summary>
        /// 人均绩效
        /// </summary>
        public Nullable<decimal> Avg { get; set; }
    
        /// <summary>
        /// 实发绩效
        /// </summary>
        public Nullable<decimal> GiveFee { get; set; }
    }
}
