//-----------------------------------------------------------------------
// <copyright file=" sys_allot.cs">
// * FileName: sys_allot.cs
// * history : 2019-03-06 16:43:26 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;

namespace Performance.EntityModels
{
    /// <summary>
    /// sys_allot Entity Model
    /// </summary>
    public class sys_allot
    {
        /// <summary>
        /// ID
        /// </summary>
        [Key]
        public int ID { get; set; }

        /// <summary>
        /// 医院ID
        /// </summary>
        public int HospitalId { get; set; }

        /// <summary>
        /// 绩效发放年
        /// </summary>
        public int Year { get; set; }

        /// <summary>
        /// 绩效发放月
        /// </summary>
        public int Month { get; set; }

        /// <summary>
        /// 绩效发放总金额
        /// </summary>
        public Nullable<decimal> AllotFee { get; set; }

        /// <summary>
        /// 绩效统计时间
        /// </summary>
        public Nullable<DateTime> CreateDate { get; set; }

        /// <summary>
        /// 文件路径
        /// </summary>
        public string Path { get; set; }

        /// <summary>
        /// 上传日期
        /// </summary>
        public Nullable<DateTime> UploadDate { get; set; }

        /// <summary>
        /// 0 数据未上传 1 数据已上传 2 数据解析中 3 数据解析成功 4 绩效结果生成中 5绩效结果解析成功 6 归档
        /// </summary>
        public int States { get; set; }
    }
}
