﻿using NPOI.SS.UserModel;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.Services
{
    public class NopiSevice
    {
        public static decimal? GetCellValue(ICell cell)
        {
            if (cell != null)
            {
                switch (cell.CellType)
                {
                    case CellType.Numeric:
                        return ConvertHelper.To<decimal?>(cell.NumericCellValue);
                    case CellType.String:
                        return ConvertHelper.To<decimal?>(cell.StringCellValue);
                    case CellType.Formula:
                        return ConvertHelper.To<decimal?>(cell.NumericCellValue);
                }
            }
            return null;
        }
    }
}
