﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 人员读取
    /// </summary>
    public class PerSheetDataReadEmployee : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 0,
            HeaderLastRowNum = 0,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 1,
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                var accountingUnit = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell).ToString();
                if (string.IsNullOrEmpty(accountingUnit))
                    continue;
                PerDataEmployee employee = new PerDataEmployee
                {
                    RowNumber = r,
                    AccountingUnit = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元").PointCell).ToString(),
                    Department = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "科室").PointCell).ToString(),
                    DoctorName = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医生姓名").PointCell).ToString(),
                    JobTitle = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "职称").PointCell).ToString(),
                    FitPeople = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "绩效基数核算参考对象").PointCell).ToString()),
                    PostCoefficient = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "岗位系数").PointCell).ToString()),
                    WorkTime = ConvertHelper.To<DateTime?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "考核得分率").PointCell).ToString()),
                    ScoreAverageRate = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医生姓名").PointCell).ToString()),
                    Attendance = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "出勤率").PointCell).ToString()),
                    PeopleNumber = ConvertHelper.To<int?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "核算单元医生数").PointCell).ToString()),
                    Workload = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "工作量绩效").PointCell).ToString()),
                    OthePerfor = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效").PointCell).ToString()),
                    Punishment = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医院奖罚").PointCell).ToString()),
                    Adjust = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "调节系数").PointCell).ToString()),
                    Grant = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "发放系数").PointCell).ToString()),
                };
                dataList.Add(employee);
            }

            return dataList;
        }
    }
}
