﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 成本
    /// </summary>
    public class PerSheetDataReadExpend : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 2,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 3,
            AccountingUnit = new List<AccountingUnit>
            {
                 new AccountingUnit
                 {
                     AccountingUnitCellNum = 0,
                     UnitType = "医生组",
                     DeptCellNum = 2
                 },
                 new AccountingUnit
                 {
                     AccountingUnitCellNum = 1,
                     UnitType = "护理组",
                     DeptCellNum = 2
                 },
            }
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            //循环 当前有几个核算单元
            foreach (var unit in Point.AccountingUnit)
            {
                //查询除了 核算单元  科室名称 有效数据列头位置
                var vhead = perHeader.Where(t => !Point.AccountingUnit.Select(p => p.AccountingUnitCellNum).Contains(t.PointCell)
                    && !Point.AccountingUnit.Select(p => p.DeptCellNum).Contains(t.PointCell)).OrderBy(t => t.PointCell);

                for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
                {
                    var row = sheet.GetRow(r);
                    for (int c = 0; c < vhead.Count(); c++)
                    {
                        //获取当前核算单元名称
                        var accountingUnit = row.GetCell(unit.AccountingUnitCellNum.Value)?.ToString();
                        //核算单元空值跳过
                        if (string.IsNullOrEmpty(accountingUnit))
                            continue;
                        var athead = vhead.ElementAt(c);

                        if (!string.IsNullOrEmpty(athead?.CellValue)
                            && Point.AccountingUnit.Any(t => athead.CellValue.Contains(t.UnitType))
                            && !athead.CellValue.Contains(unit.UnitType))
                            continue;
                        if (!string.IsNullOrEmpty(athead?.CellValue) && athead.CellValue.Contains("备注"))
                            continue;
                        var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                        if (!cellValue.HasValue || cellValue.Value == 0)
                            continue;

                        PerData data = new PerData
                        {
                            RowNumber = r,
                            SignID = athead.SignID,
                            AccountingUnit = accountingUnit,
                            Department = row.GetCell(unit.DeptCellNum.Value)?.ToString(),
                            TypeName = athead?.CellValue,
                            CellValue = ConvertHelper.To<decimal?>(row.GetCell(athead.PointCell)?.ToString()),
                            Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                            UnitType = unit.UnitType, //手动匹配   
                            IsFactor = false,
                        };
                        var lastcell = vhead.OrderByDescending(t => t.PointCell).First();
                        if (lastcell.CellValue.Contains("备注"))
                            data.Remark = row.GetCell(lastcell.PointCell)?.ToString();
                        dataList.Add(data);
                    }
                }
            }
            return dataList;
        }
    }
}
