﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 其他收入
    /// </summary>
    public class PerSheetDataReadOtherIncome : IPerSheetDataRead
    {

        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 2,
            AccountingUnit = new List<AccountingUnit>
            {
                new AccountingUnit
                {
                    AccountingUnitCellNum = 0,
                    DeptCellNum = 1
                }
            }
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            var unit = Point.AccountingUnit.First();
            //查询除了 核算单元  科室名称 有效数据列头位置
            var vhead = perHeader.Where(t => t.PointCell != unit.AccountingUnitCellNum && t.PointCell != unit.DeptCellNum).OrderBy(t => t.PointCell);

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                for (int c = 0; c < vhead.Count(); c++)
                {
                    //获取当前核算单元名称
                    var accountingUnit = row.GetCell(unit.AccountingUnitCellNum.Value)?.ToString();
                    //核算单元空值跳过
                    if (string.IsNullOrEmpty(accountingUnit))
                        continue;
                    var athead = vhead.ElementAt(c);
                    var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                    if (!cellValue.HasValue || cellValue.Value == 0)
                        continue;
                    PerData data = new PerData
                    {
                        RowNumber = r,
                        SignID = athead.SignID,
                        AccountingUnit = accountingUnit,
                        Department = row.GetCell(unit.DeptCellNum.Value)?.ToString(),
                        TypeName = athead?.CellValue,
                        CellValue = cellValue,
                        Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                        UnitType = GetUnitType(sheet.SheetName, perHeader),
                        IsFactor = false,
                    };

                    dataList.Add(data);
                }
            }

            return dataList;
        }

        /// <summary>
        /// 获取核算单元类型
        /// </summary>
        /// <param name="sheet"></param>
        /// <param name="perHeader"></param>
        private string GetUnitType(string sheetName, List<PerHeader> perHeader)
        {
            if (sheetName.Contains("医生组"))
                return "医生组";
            else if (sheetName.Contains("护理组"))
                return "护理组";
            else if (perHeader.Any(t => t.CellValue.Contains("核算单元") && t.CellValue.Contains("医生组")))
                return "医生组";
            else if (perHeader.Any(t => t.CellValue.Contains("核算单元") && t.CellValue.Contains("护理组")))
                return "护理组";
            return "";
        }
    }
}
