﻿using System;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Options;
using Performance.DtoModels.AppSettings;
using Performance.Infrastructure;
using Performance.Repository;

namespace Performance.Api.Configurations
{
    public static class AppSettingConfig
    {
        public static void AddAppSettingConfiguration(this IServiceCollection services, IConfiguration configuration)
        {
            if (services == null) throw new ArgumentNullException(nameof(services));

            services
                .Configure<AppConnection>(configuration.GetSection("AppConnection"))
                .Configure<Application>(configuration.GetSection("Application"))
                .Configure<HuyiSmsConfig>(configuration.GetSection("HuyiSmsConfig"))
                .Configure<EmailOptions>(configuration.GetSection("EmailOptions"))
                .Configure<RateLimitingConfig>(configuration.GetSection("RateLimitingConfig"))
                .Configure<WebapiUrl>(configuration.GetSection("WebapiUrl"))
                .Configure<AppSQLEncrypt>(configuration.GetSection("AppSQLEncrypt"));

            var options = services.BuildServiceProvider().GetRequiredService<IOptions<AppSQLEncrypt>>();
            AppSQLEncryptConfig.Instance = options?.Value ?? new AppSQLEncrypt();

        }
    }
}
