﻿using System.Linq;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.Services;

namespace Performance.Api.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    public class CommonController : ControllerBase
    {
        private readonly CommonService _service;

        public CommonController(CommonService service)
        {
            _service = service;
        }

        [AllowAnonymous]
        [HttpGet("version")]
        public ApiResponse Version()
        {
            var versions = _service.GetVersions();
            return new ApiResponse(ResponseType.OK, versions.Select(w => new
            {
                w.Id,
                w.VersionCode,
                PublishTime = w.PublishTime.ToString("yyyyy-MM-dd"),
                w.Content,
            }));
        }
    }
}
