﻿namespace Performance.DtoModels.AppSettings
{
    public class Application
    {
        /// <summary>
        /// 登录过期时间
        /// </summary>
        public int ExpirationMinutes { get; set; }
        /// <summary>
        /// 验证码过期
        /// </summary>
        public int SmsCodeMinutes { get; set; }
        /// <summary>
        /// 短信模板
        /// </summary>
        public string SmsTemplate { get; set; }
        /// <summary>
        /// 邮件指定接收人
        /// </summary>
        public string[] Receiver { get; set; }
        /// <summary>
        /// 绝对路径
        /// </summary>
        public string AbsolutePath { get; set; }
        /// <summary>
        /// 相对
        /// </summary>
        public string HttpPath { get; set; }
        /// <summary>
        /// 是否开启反SQL注入 默认关闭  true 开启  false 关闭
        /// </summary>
        public bool? OpenAntiSqlInject { get; set; }
        /// <summary>
        /// 开启反SQL注入白名单地址
        /// </summary>
        public string[] AntiSqlInjectRouteWhite { get; set; }
        /// <summary>
        /// 夜班绩效文本名称
        /// </summary>
        public string[] NightShiftTexts { get; set; }
    }
}
