﻿namespace Performance.DtoModels.OAuth
{
    public class TokenResponse : IOAuthResponse
    {
        /// <summary>
        /// 表示访问令牌，必选项。
        /// </summary>
        public string access_token { get; set; }
        /// <summary>
        /// 表示令牌类型，该值大小写不敏感，必选项，可以是 bearer类型或 mac 类型，IDTrust 目前固定为 bearer 类型。
        /// </summary>
        public string token_type { get; set; }
        /// <summary>
        /// 表示过期时间，单位为秒。IDTrust 设备 token 有效期为 1小时。
        /// </summary>
        public string? expires_in { get; set; }
        /// <summary>
        /// 表示更新令牌，用来获取下一次的访问令牌。
        /// </summary>
        public string refresh_token { get; set; }
        /// <summary>
        /// 表示权限范围，如果与客户端申请的范围一致。
        /// </summary>
        public string scope { get; set; }
    }
}
