﻿using System;
using System.Collections.Generic;
using Performance.EntityModels;

namespace Performance.DtoModels
{
    public class ReportData
    {
        public ReportData(rep_report report)
        {
            ReportID = report.ID;
            ChartType = report.ChartType;
            Sort = report.Sort;
            Title = report.Title;
            QueryName = report.QueryName;
            QueryArguments = report.QueryArguments;
            XTitle = report.XTitle;
            XUnit = report.XUnit;
            YTitle = report.YTitle;
            YUnit = report.YUnit;
            VTitle = report.VTitle;
            VUnit = report.VUnit;
            NTitle = report.NTitle;
            NUnit = report.NUnit;
            Formula = report.Formula;
            DataType = report.DataType;
            FilterValue = report.FilterValue;
            ChartData = new List<ChartData>();
        }

        public int ReportID { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Nullable<int> ChartType { get; set; }

        /// <summary>
        ///
        /// </summary>
        public Nullable<int> Sort { get; set; }

        /// <summary>
        /// 报表标题
        /// </summary>
        public string Title { get; set; }

        /// <summary>
        /// 查询方法名称
        /// </summary>
        public string QueryName { get; set; }

        /// <summary>
        /// 查询参数
        /// </summary>
        public string QueryArguments { get; set; }

        /// <summary>
        /// X轴标题
        /// </summary>
        public string XTitle { get; set; }

        /// <summary>
        /// X轴单位
        /// </summary>
        public string XUnit { get; set; }

        /// <summary>
        /// Y轴标题
        /// </summary>
        public string YTitle { get; set; }

        /// <summary>
        /// Y轴单位
        /// </summary>
        public string YUnit { get; set; }

        /// <summary>
        /// 值标题
        /// </summary>
        public string VTitle { get; set; }

        /// <summary>
        /// 值单位
        /// </summary>
        public string VUnit { get; set; }

        /// <summary>
        /// name标题
        /// </summary>
        public string NTitle { get; set; }

        /// <summary>
        /// name单位
        /// </summary>
        public string NUnit { get; set; }

        /// <summary>
        /// 图表说明
        /// </summary>
        public string Formula { get; set; }

        /// <summary>
        /// 1表示需要进行小于百分2的类型进行合并
        /// </summary>
        public Nullable<int> DataType { get; set; }

        /// <summary>
        /// 图标value过滤执值
        /// </summary>
        public Nullable<decimal> FilterValue { get; set; }

        /// <summary>
        /// 图表数据
        /// </summary>
        public List<ChartData> ChartData { get; set; }
    }

    /// <summary>
    /// 图表
    /// </summary>

    public class ChartData
    {
        /// <summary>
        /// X轴内容
        /// </summary>
        public string X { get; set; }

        /// <summary>
        /// Y轴内容
        /// </summary>
        public string Y { get; set; }

        /// <summary>
        /// 分类
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 值
        /// </summary>
        public decimal Value { get; set; }

        /// <summary>
        /// 总量
        /// </summary>
        public Nullable<decimal> Total { get; set; }

        /// <summary>
        /// ChartData 类型标签
        /// </summary>
        public string Type { get; set; }
    }
}
