﻿using System.Collections.Generic;
using Performance.EntityModels;

namespace Performance.DtoModels
{
    public class CostTransferRequest
    {
        public int AllotId { get; set; }

        public DepartmentDetail Applicant { get; set; }

        public DepartmentDetail Adopted { get; set; }

        public List<CostTransferItemRequest> Items { get; set; }
    }

    public class DepartmentDetail
    {
        public string UnitType { get; set; }

        public string Department { get; set; }
    }

    public class CostTransferUpdateRequest : CostTransferRequest
    {
        public int TransferId { get; set; }



        public new List<cost_transfer_item> Items { get; set; }
    }

    public class AuditRequest
    {
        public int AllotId { get; set; }
        public int[] TransferItemId { get; set; }

        public int Status { get; set; }

        public string Remake { get; set; }
    }
}
