﻿namespace Performance.DtoModels.Request
{
    public class MenuRequest
    {
        public int ID { get; set; }
        /// <summary>
        /// 父级菜单ID
        /// </summary>
        public int ParentID { get; set; }
        /// <summary>
        /// 菜单名称
        /// </summary>
        public string MenuName { get; set; }
        /// <summary>
        /// 菜单Url
        /// </summary>
        public string? MenuUrl { get; set; }
        /// <summary>
        /// 菜单状态 1 启用 2禁用
        /// </summary>
        public int States { get; set; }
        /// <summary>
        /// 排序
        /// </summary>
        public int? Sort { get; set; }
    }

    public class RoleRequest
    {
        /// <summary>
        /// 菜单id
        /// </summary>
        public int MenuID { get; set; }
        /// <summary>
        /// 角色
        /// </summary>
        public int[] RoleID { get; set; }
        /// <summary>
        /// 为父级添加相同角色
        /// </summary>
        public bool TogetherAdd { get; set; }
    }
}
