﻿using FluentValidation;

namespace Performance.DtoModels
{
    public class PositionRequest
    {
        public int ID { get; set; }

        /// <summary>
        /// 绩效ID
        /// </summary>
        public int AllotID { get; set; }

        /// <summary>
        /// 职位名称
        /// </summary>
        public string JobTitle { get; set; }

        /// <summary>
        /// 职位归类 1 院领导 2 行政中层 3 行政工勤 4 临床科室主任 5 临床科室副主任 6 临床科室护士长
        /// </summary>
        public int JobType { get; set; }

        /// <summary>
        /// 额外补偿系数
        /// </summary>
        public decimal ExtraFactor { get; set; }

        /// <summary>
        /// 职位类别 1 普通类别 2 基础绩效来源
        /// </summary>
        public int State { get; set; }


        public class PositionRequestValidator : AbstractValidator<PositionRequest>
        {
            public PositionRequestValidator()
            {
                RuleSet("Select", () =>
                {
                    RuleFor(x => x.AllotID).NotNull().NotEmpty().GreaterThan(0);
                });

                RuleSet("Update", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });

                RuleSet("Delete", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });
            }
        }
    }
}
