﻿using FluentValidation;

namespace Performance.DtoModels
{
    public class ReportRequest
    {
        public int HospitalId { get; set; }

        /// <summary> 是否为首页 </summary>
        public int IsIndex { get; set; }

        /// <summary> 是否以年为单位 </summary>
        public int OnlyYear { get; set; }

        /// <summary> 报表名称 </summary>
        public string Source { get; set; }

        /// <summary> 年 </summary>
        public string Year { get; set; }

        /// <summary> 月 </summary>
        public string Month { get; set; }

        /// <summary> 科室 </summary>
        public string[] AccountingUnit { get; set; }
    }
    public class ReportRequestValidator : AbstractValidator<ReportRequest>
    {
        public ReportRequestValidator()
        {
            RuleSet("Query", () =>
            {
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
            });

            RuleSet("Index", () =>
            {
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                RuleFor(x => x.Source).NotNull().NotEmpty();
            });

            RuleSet("Menu", () =>
            {
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                RuleFor(x => x.OnlyYear).NotNull();
                RuleFor(x => x.Source).NotNull().NotEmpty();
            });
        }
    }
}
