﻿using FluentValidation;

namespace Performance.DtoModels
{
    public class SecondEmployeeRequest
    {
        public string EmployeeName { get; set; }

        public string JobNumber { get; set; }
    }

    public class SecondEmpRequest : SecondEmployeeRequest
    {
        public int TempId { get; set; }

        public int SecondId { get; set; }
    }

    public class SecondEmpRequestValidator : AbstractValidator<SecondEmpRequest>
    {
        public SecondEmpRequestValidator()
        {
            //RuleFor(x => x.TempId).NotNull().GreaterThan(0);
            RuleFor(x => x.SecondId).NotNull().GreaterThan(0);
        }
    }
}
