﻿using FluentValidation;

namespace Performance.DtoModels
{
    public class WorkDetailRequest
    {
        public int AllotId { get; set; }
        //public int SecondId { get; set; }
        public string Source { get; set; }
        public string AccountingUnit { get; set; }
    }

    public class WorkDetailRequestValidator : AbstractValidator<WorkDetailRequest>
    {
        public WorkDetailRequestValidator()
        {
            RuleSet("Select", () =>
            {
                RuleFor(x => x.AllotId).NotNull().NotEmpty().GreaterThan(0);
                RuleFor(x => x.AccountingUnit).NotNull().NotEmpty();
            });
        }
    }
}
