﻿using System;
using System.Collections.Generic;
using Performance.Infrastructure;

namespace Performance.DtoModels
{
    public class SheetExportResponse
    {
        /// <summary>
        /// sheetID
        /// </summary>
        public int SheetID { get; set; }
        /// <summary>
        /// sheet名称
        /// </summary>
        public string SheetName { get; set; }
        /// <summary>
        /// sheet模板类型
        /// </summary>
        public int SheetType { get; set; }

        /// <summary>
        /// sheet头
        /// </summary>
        public List<Row> Header { get; set; }

        /// <summary>
        /// sheet数据
        /// </summary>
        public List<Row> Row { get; set; }

        public SheetExportResponse()
        {
            Header = new List<Row>();
            Row = new List<Row>();
        }
        public SheetExportResponse(string sheetName)
        {
            SheetName = sheetName;
            Header = new List<Row>();
            Row = new List<Row>();
        }

        public SheetExportResponse(int sheetID, string sheetName, int sheetType)
        {
            SheetID = sheetID;
            SheetName = sheetName;
            SheetType = sheetType;
            Header = new List<Row>();
            Row = new List<Row>();
        }
    }

    public class Row
    {
        public int Rownumber { get; set; }
        public List<Cell> Data { get; set; }

        public Row() { }
        public Row(int rownumber)
        {
            Rownumber = rownumber;
            Data = new List<Cell>();
        }
    }

    public class Cell
    {
        public int PointCell { get; set; }

        private object cellValue;
        public object CellValue
        {
            get
            {
                var value = ConvertHelper.ToDecimalOrNull(cellValue);
                if (value.HasValue && value.Value > 0)
                    return Math.Round(value.Value, 2);
                return cellValue;
            }
            set
            {
                cellValue = value;
            }
        }
        public int MergeRow { get; set; }
        public int MergeCell { get; set; }
        public bool IsTotal { get; set; }
        public bool IsNumValue { get; set; }
        /// <summary>
        /// 单元格注释
        /// </summary>
        public string Annotation { get; set; }

        public int Id { get; set; }
        /// <summary>
        /// 数据库字段名称
        /// </summary>
        public string FieldName { get; set; }
        /// <summary>
        /// 单元格数据分类
        /// </summary>
        public string CellType { get; set; }


        public Cell() { }
        public Cell(int pointCell, object cellValue, int mergeRow, int mergeCell, bool isTotal, bool isNumValue, string annotation = "", int id = 0, string fieldName = "", string cellType = "body")
        {
            PointCell = pointCell;
            CellValue = cellValue;
            MergeRow = mergeRow;
            MergeCell = mergeCell;
            IsTotal = isTotal;
            IsNumValue = isNumValue;
            Annotation = annotation;
            Id = id;
            FieldName = fieldName;
            CellType = cellType;
        }
    }
}
