//-----------------------------------------------------------------------
// <copyright file=" per_assess_scheme_target.cs">
// * FileName: 被考核对象.cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 被考核对象
    /// </summary>
    [Table("per_assess_scheme_target")]
    public class per_assess_scheme_target
    {
        /// <summary>
        /// 被考核对象Id
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 绩效ID
        /// </summary>
        public Nullable<int> AllotId { get; set; }
        /// <summary>
        /// 考核类型ID
        /// </summary>
        public int AssessId { get; set; }
        /// <summary>
        /// 考核方案Id
        /// </summary>
        public int SchemeId { get; set; }
        /// <summary>
        /// 考核目标核算单元编码
        /// </summary>
        public string UnitCode { get; set; }
        /// <summary>
        /// 考核目标核算组别
        /// </summary>
        public string UnitType { get; set; }
        /// <summary>
        /// 考核目标核算单元
        /// </summary>
        public string AccountingUnit { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public int CreateBy { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? CreateTime { get; set; }
        /// <summary>
        /// 最后修改人
        /// </summary>
        public int UpdateBy { get; set; }
        /// <summary>
        /// 修改时间
        /// </summary>
        public DateTime? UpdateTime { get; set; }
    }
}
