//-----------------------------------------------------------------------
// <copyright file=" sys_extract.cs">
// * FileName: sys_extract.cs
// </copyright>
//-----------------------------------------------------------------------
using System.Collections.Generic;
using System.Data;
using Dapper;
using Performance.EntityModels;

namespace Performance.Repository
{
    /// <summary>
    /// sys_extract Repository
    /// </summary>
    public partial class PerforExtractRepository : PerforRepository<sys_extract>
    {
        public List<CustomExecute> ExecuteScript(IDbConnection connection, string sql, string param)
        {
            List<CustomExecute> result = new List<CustomExecute>();
            using (connection)
            {
                var dataReader = connection.ExecuteReader(sql, param, commandTimeout: 1000 * 3600 * 24);
                int row = 0;
                while (dataReader.Read())
                {
                    for (int i = 0; i < dataReader.FieldCount; i++)
                    {
                        var fileName = dataReader.GetName(i);
                        var @object = dataReader[fileName];
                        result.Add(new CustomExecute { RowNumber = row, ColumnName = fileName, Value = @object });
                    }
                    row++;
                }
            }
            return result;
        }
    }

    public class CustomExecute
    {
        public int RowNumber { get; set; }
        public string ColumnName { get; set; }
        public object Value { get; set; }
    }
}
