﻿using System.Linq;
using Microsoft.EntityFrameworkCore;
using Performance.EntityModels;
using Performance.Infrastructure.Models;

namespace Performance.Repository
{
    public partial class PerforExtypeRepository
    {
        public PageList<ex_type> GetPagingData(int hospitalId, int? sheetType, string search, int pageNumber, int pageSize)
        {
            var query = _context.ex_type.AsNoTracking().Where(w => w.HospitalId == hospitalId);
            if (sheetType.HasValue && sheetType.Value > 0)
            {
                query = query.Where(w => w.Source == sheetType);
            }
            if (!string.IsNullOrEmpty(search))
            {
                query = query.Where(w => w.EName.Contains(search));
            }

            return PageList<ex_type>.Create(query, pageNumber, pageSize);
        }
    }
}
