//-----------------------------------------------------------------------
// <copyright file=" im_employee.cs">
// * FileName: im_employee.cs
// </copyright>
//-----------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;
using Performance.EntityModels;

namespace Performance.Repository
{
    /// <summary>
    /// im_employee Repository
    /// </summary>
    public partial class PerforImemployeeRepository : PerforRepository<im_employee>
    {
        public List<im_employee> GetEmployees(int allotId)
        {
            return context.Set<im_employee>()
                 .Where(w => w.AllotID == allotId)
                 .ToList()
                 .GroupBy(w => w.PersonnelNumber)
                 .Select(w => w.OrderByDescending(p => p.ID).First())
                 .ToList()
                 ?? new List<im_employee>();
        }
    }
}
