﻿using System.Collections.Generic;
using System.Linq;
using Microsoft.Extensions.Logging;
using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.EntityModels;

namespace Performance.Services.ExtractExcelService.SheetDataWrite
{
    public class DepartmentDataWrite : ISheetDataWrite
    {
        private readonly ILogger logger;

        public DepartmentDataWrite(ILogger logger)
        {
            this.logger = logger;
        }

        public void WriteCollectData(ISheet sheet, PerSheetPoint point, SheetType sheetType, ExcelStyle style, List<collect_data> collects, Dictionary<ExDataDict, object> exdict = null)
        {
            if (collects == null || !collects.Any(t => !string.IsNullOrEmpty(t.TypeName))) return;

            var columns = collects.Where(t => !string.IsNullOrEmpty(t.TypeName)).Select(t => t.TypeName).Distinct().OrderBy(t => t).ToList();

            var headers = columns.Select(t => new ExcelHeader
            {
                ColumnName = t.NoBlank(),
                DoctorFactor = 0,
                NurseFactor = 0,
                TechnicianFactor = 0
            }).ToList();

            point = new PerSheetPoint
            {
                HeaderFirstRowNum = 1,
                HeaderFirstCellNum = 1,
                DataFirstRowNum = 2,
                DataFirstCellNum = 3
            };
            ExtractHelper.ClearSheetPartialData(sheet, point, sheetType);

            WriteDataHelper.WriteSheetHeader(sheet, point, sheetType, style, headers);
            WriteDataHelper.WriteCollectData(sheet, point, sheetType, style, columns, collects);
        }

        public void WriteSheetData(ISheet sheet, PerSheetPoint point, SheetType sheetType, ExcelStyle style, object data, Dictionary<ExDataDict, object> exdict = null)
        {
        }
    }
}
