﻿using System.Collections.Generic;
using System.Linq;
using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;

namespace Performance.Services
{
    /// <summary>
    /// 临床科室单元核算表
    /// </summary>
    public class PerSheetDataReadDeptAccountingSpecial : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 2,
            AccountingUnit = new List<AccountingUnit>
            {
               new AccountingUnit
               {
                    AccountingUnitCellNum = 1,
                    //DeptCellNum = 2,
               }
            }
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            var unit = Point.AccountingUnit.First();
            //查询除了 核算单元  科室名称 有效数据列头位置
            var vhead = perHeader.OrderBy(t => t.PointCell);

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                for (int c = 0; c < vhead.Count(); c++)
                {
                    var athead = vhead.ElementAt(c);
                    //var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                    var cellValue = ConvertHelper.ToDecimalOrNull(row.GetCell(athead.PointCell).GetValue());
                    if (!cellValue.HasValue || cellValue.Value == 0)
                        continue;

                    PerData data = new PerData
                    {
                        RowNumber = r,
                        SignID = athead.SignID,
                        AccountingUnit = row.GetCell(unit.AccountingUnitCellNum.Value).GetValue(),
                        //Department = NopiSevice.GetCellStringValue(row.GetCell(unit.DeptCellNum.Value)),
                        TypeName = athead?.CellValue,
                        CellValue = cellValue,
                        //Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                        UnitType = row.GetCell(0)?.ToString(),
                        FactorValue = 0,
                        IsFactor = false,
                    };

                    if (sheet.SheetName.Contains("医生组"))
                        data.UnitType = "医生组";
                    else if (sheet.SheetName.Contains("护理组"))
                        data.UnitType = "护理组";

                    if (!string.IsNullOrEmpty(data.UnitType))
                        dataList.Add(data);
                }
            }

            return dataList;
        }
    }
}
