﻿using System.Collections.Generic;
using System.Linq;
using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;

namespace Performance.Services
{
    /// <summary>
    /// 工作量
    /// </summary>
    public class PerSheetDataReadWorkload : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 1,
            DataFirstRowNum = 3,
            DataFirstCellNum = 3,
            AccountingUnit = new List<AccountingUnit>
            {
               new AccountingUnit
               {
                    AccountingUnitCellNum = 1,
                    DeptCellNum = 2,
                    FactorRow = 2
               }
            }
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();

            var unit = Point.AccountingUnit.First();
            //查询除了 核算单元  科室名称 有效数据列头位置
            var vhead = perHeader.Where(t => t.PointCell != unit.AccountingUnitCellNum && t.PointCell != unit.DeptCellNum).OrderBy(t => t.PointCell);

            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                for (int c = 0; c < vhead.Count(); c++)
                {
                    var athead = vhead.ElementAt(c);
                    //var cellValue = NopiSevice.GetCellValue(row.GetCell(athead.PointCell));
                    var cellValue = ConvertHelper.ToDecimalOrNull(row.GetCell(athead.PointCell).GetValue());
                    if (!cellValue.HasValue || cellValue.Value == 0)
                        continue;

                    PerData data = new PerData
                    {
                        RowNumber = r,
                        SignID = athead.SignID,
                        AccountingUnit = row.GetCell(unit.AccountingUnitCellNum.Value).GetValue(),
                        Department = row.GetCell(unit.DeptCellNum.Value).GetValue(),
                        TypeName = athead?.CellValue,
                        CellValue = cellValue,
                        //Annotation = row.GetCell(athead.PointCell)?.CellComment?.String?.String,
                        UnitType = unit.UnitType,
                        FactorValue = ConvertHelper.ToDecimalOrNull(sheet.GetRow(unit.FactorRow.Value).GetCell(athead.PointCell).GetValue()),
                        IsFactor = true,
                    };
                    if (sheet.SheetName.Contains("医生组"))
                        data.UnitType = "医生组";
                    else if (sheet.SheetName.Contains("护理组"))
                        data.UnitType = "护理组";

                    if (string.IsNullOrEmpty(data.AccountingUnit) && string.IsNullOrEmpty(data.Department))
                        continue;
                    dataList.Add(data);
                }
            }

            return dataList;
        }
    }
}
