﻿using Microsoft.Extensions.Logging;
using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services.ExtractExcelService.SheetDataWrite
{
    public class IncomeDataWrite : ISheetDataWrite
    {
        private readonly ILogger logger;

        public IncomeDataWrite(ILogger logger)
        {
            this.logger = logger;
        }

        public void WriteCollectData(ISheet sheet, PerSheetPoint point, SheetType sheetType, ExcelStyle style, List<collect_data> collects, Dictionary<ExDataDict, object> exdict = null)
        {
            if (collects == null || !collects.Any(t => !string.IsNullOrEmpty(t.TypeName))) return;

            var columns = collects.Where(t => !string.IsNullOrEmpty(t.TypeName)).Select(t => t.TypeName).Distinct().OrderBy(t => t).ToList();

            var headers = columns.Select(t => new ExcelHeader
            {
                ColumnName = t.Trim(),
                DoctorFactor = 0,
                NurseFactor = 0,
                TechnicianFactor = 0
            }).ToList();

            WriteDataHelper.WriteSheetHeader(sheet, point, sheetType, style, headers);
            WriteDataHelper.WriteCollectData(sheet, point, sheetType, style, columns, collects);
        }

        public void WriteSheetData(ISheet sheet, PerSheetPoint point, SheetType sheetType, ExcelStyle style, object data, Dictionary<ExDataDict, object> exdict = null)
        {
            var modules = exdict[ExDataDict.ExModule] as List<ex_module>;
            var module = modules?.FirstOrDefault(t => t.SheetType == (int)sheetType && t.ModuleName.NoBlank() == sheet.SheetName.NoBlank());
            if (module == null) return;

            if (data is List<ExtractTransDto> extractDto && extractDto.Any())
            {
                var headers = new List<ExcelHeader>();
                var categories = extractDto.Select(t => t.Category?.Trim() ?? "").Distinct();
                if (exdict.ContainsKey(ExDataDict.IncomeFactor) && exdict[ExDataDict.IncomeFactor] is List<cof_drugtype_factor> factors && factors.Any(t => t.ExModuleId == module.Id))
                {
                    factors = factors.Where(t => t.ExModuleId == module.Id).ToList();
                    headers = categories.GroupJoin(factors, inner => new { category = inner.NoBlank() }, outer => new { category = outer.Charge.NoBlank() }, (inner, outer) => new { inner, outer })
                        .Select(t => new ExcelHeader
                        {
                            ColumnName = t.inner,
                            DoctorFactor = t.outer?.FirstOrDefault()?.YSZ,
                            NurseFactor = t.outer?.FirstOrDefault()?.HLZ,
                            TechnicianFactor = t.outer?.FirstOrDefault()?.YJZ,
                        }).ToList();
                }
                else
                {
                    headers = categories.Select(t => new ExcelHeader
                    {
                        ColumnName = t,
                    }).ToList();
                }

                WriteDataHelper.WriteSheetHeader(sheet, point, sheetType, style, headers);
                var columns = headers.Select(t => t.ColumnName).ToList();
                WriteDataHelper.WriteSheetData(sheet, point, sheetType, style, columns, extractDto);
            }
        }
    }
}
