﻿using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Performance.Services
{
    /// <summary>
    /// 合并科室经济
    /// </summary>
    public class PerSheetDataComputeEconomicMerge
    {
        /// <summary>
        /// 计算科室经济核算汇总表
        /// </summary>
        /// <param name="excel"></param>
        /// <returns></returns>
        public PerSheet MergeCompute(PerExcel excel)
        {
            PerSheet compSheet = new PerSheet
            {
                SheetName = "科室经济核算汇总表",
                ModuleName = "科室经济核算汇总表",
                PerHeader = new List<PerHeader>(),
                PerData = new List<IPerData>()
            };

            List<PerData> perDataList = new List<PerData>();
            //初始核算单元列头 
            compSheet.PerHeader.Add(new PerHeader { CellValue = "核算单元", Level = 0, MergeCell = 1, MergeRow = 2, PointCell = 0, PointRow = 0 });
            //起始列
            int pointCell = 1;
            //计算需从以下sheet中拿取数据
            SheetType[] types = { SheetType.Income, SheetType.OtherIncome, SheetType.Expend };
            foreach (var type in types)
            {
                //取出当前sheet类型数据
                var sheetList = excel.PerSheet.Where(t => t.SheetType == type);
                if (sheetList.Any())
                {
                    List<PerHeader> headList = new List<PerHeader>();
                    //子集列号为父级列号
                    int childPointCell = pointCell;
                    foreach (var sheet in sheetList)
                    {
                        var dataList = sheet.PerData.Select(t => (PerData)t);
                        foreach (var group in dataList.GroupBy(t => t.UnitType))
                        {
                            var typeName = $"{GetCleanSheetName(sheet.SheetName)}({ group.Key})";
                            //创建子集头部信息
                            PerHeader childHeader = new PerHeader(1, childPointCell, typeName, 1, 1, 1, null, 2);
                            headList.Add(childHeader);

                            var ds = group.Where(t => t.CellValue.HasValue && t.CellValue.Value > 0)
                                .GroupBy(t => t.AccountingUnit).Select(t => new PerData
                                {
                                    SignID = childHeader.SignID,
                                    UnitType = group.Key,
                                    AccountingUnit = t.Key,
                                    CellValue = t.Sum(s => s.IsFactor ? (s.CellValue * (s.FactorValue ?? 0)) : s.CellValue),
                                    TypeName = typeName,
                                    RowNumber = dataList.FirstOrDefault(s => s.AccountingUnit == t.Key && s.UnitType == group.Key)?.RowNumber ?? 0,
                                    ComputRule = type == SheetType.Expend ? 2 : 1
                                });

                            perDataList.AddRange(ds);
                            childPointCell++;
                        }
                    }
                    PerHeader header = new PerHeader(0, pointCell, EnumHelper.GetDescription(type), 1, 1, headList.Count, headList, 2);
                    compSheet.PerHeader.Add(header);
                    //父级列号为当前列号+子集个数
                    pointCell = pointCell + headList.Count;
                }
            }
            int number = 0;
            foreach (var accountingUnit in perDataList.OrderBy(t => t.RowNumber).Select(t => t.AccountingUnit).Distinct())
            {
                perDataList.Where(t => t.AccountingUnit == accountingUnit).ToList().ForEach(item => item.RowNumber = number);
                number++;
            }
            compSheet.PerData.AddRange(perDataList);

            return compSheet;
        }

        private string GetCleanSheetName(string sheetName)
        {
            sheetName = sheetName.Trim()
               .Replace("医生组", "")
               .Replace("护理组", "")
               .Replace(".", "");

            sheetName = Regex.Replace(sheetName, @"\d", "");

            return sheetName;
        }
    }
}
