﻿using Performance.DtoModels;

namespace Performance.Services.OnlineExcel
{
    public partial class OnlineExcelService
    {
        public class ExcelSheetInfo
        {
            public string Name { get; set; }
            public int Row { get; set; }
            public int Column { get; set; }
            public string Version { get; set; }
            public string Message
            {
                get
                {
                    if (Row * Column > 500 * 50)
                        return "数据量很大，加载需要较长时间";
                    else if (Row * Column > 100 * 50)
                        return "数据较多，可能需要较长加载时间";
                    return "";
                }
            }

            public SheetType SheetType { get; internal set; }
            public string ModuleName { get; internal set; }
        }
    }
}