﻿using AutoMapper;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class RoleService : IAutoInjection
    {
        private readonly IMapper _mapper;
        private PerforRoleRepository _roleRepository;
        private PerforUserroleRepository _userroleRepository;
        private PerforUserRepository _userRepository;

        public RoleService(
            IMapper mapper,
            PerforRoleRepository roleRepository,
            PerforUserroleRepository userroleRepository,
            PerforUserRepository userRepository)
        {
            _mapper = mapper;
            this._roleRepository = roleRepository;
            this._userroleRepository = userroleRepository;
            _userRepository = userRepository;
        }

        /// <summary>
        /// 获取用户角色
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public List<RoleResponse> GetUserRole(int userid)
        { 
            var roles = GetRole(userid);
            return _mapper.Map<List<RoleResponse>>(roles);
        }


        /// <summary>
        /// 获取用户角色
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public List<sys_role> GetRole(int userid)
        {
            if (userid <= 0)
                throw new PerformanceException($"userid：{userid} 错误");

            var joinList = _userroleRepository.GetEntities(t => t.UserID == userid);
            if (joinList == null && joinList.Count == 0)
                return null;

            var roles = _roleRepository.GetEntities(t => joinList.Select(j => j.RoleID).Contains(t.ID));

            return roles;
        }

        public List<RoleResponse> GetUsersRole(int userid)
        {
            List<RoleResponse> roleResponses = new List<RoleResponse>();
            var user=_userRepository.GetEntity(c => c.ID == userid);
            var ParentUser = _userRepository.GetEntities(c => c.ParentID == userid);
            if (user.ParentID!=null && user.ParentID!=0)
            {
                ParentUser=_userRepository.GetEntities(c => c.ParentID == user.ParentID);
            }
            
            if (ParentUser != null)   
            {
                var userRole = _userroleRepository.GetEntities();
                foreach (var sysUser in ParentUser)
                {
                    var useRoles = GetARole(sysUser.ID);
                    var role = _mapper.Map<RoleResponse>(useRoles);
                    var uRole = userRole.Find(t => t.RoleID == role.RoleID && t.UserID == sysUser.ID);
                    if (uRole?.UserID != null) role.Value = (int)uRole?.UserID;
                    roleResponses.Add(role);
                }
            }

            var isParent = user.ParentID == null || user.ParentID == 0;
            var roles = GetARole(isParent ? userid : (int)user.ParentID);
            if (roles != null)

            {
                var role = _mapper.Map<RoleResponse>(roles);
                role.Value = isParent ? userid : (int)user.ParentID;
                roleResponses.Add(role);
            }
            return roleResponses?.OrderBy(t => t.Type).ToList();
        }

        /// <summary>
        /// 获取用户角色
        /// </summary>
        /// <param name="userid"></param>
        /// <returns></returns>
        public sys_role GetARole(int userid)
        {
            if (userid <= 0)
                throw new PerformanceException($"userid：{userid} 错误");

            var joinList = _userroleRepository.GetEntities(t => t.UserID == userid);
            if (joinList == null)
                return null;

            var roles = _roleRepository.GetEntity(t => joinList.Select(j => j.RoleID).Contains(t.ID));

            return roles;
        }
    }
}
