﻿using Performance.DtoModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class UnitTypeUtil
    {
        public static string[] Office = new string[] { "行政后勤", "行政工勤" };

        /// <summary>
        /// 是否是行政后勤/工勤
        /// </summary>
        /// <param name="unit"></param>
        /// <returns></returns>
        public static bool IsOffice(int? unit)
        {
            return unit == (int)UnitType.行政后勤;
        }

        /// <summary>
        /// 是否是行政后勤/工勤
        /// </summary>
        /// <param name="unit"></param>
        /// <returns></returns>
        public static bool IsOffice(string unit)
        {
            return !string.IsNullOrEmpty(unit) && Office.Contains(unit);
        }

        /// <summary>
        /// 获得标准名 行政后勤/工勤
        /// </summary>
        /// <param name="unit"></param>
        /// <returns></returns>
        public static string GetOffice(string unit)
        {
            return string.IsNullOrEmpty(unit) ? "" : unit.Replace("行政后勤", "行政工勤");
        }

        /// <summary>
        /// 核算单元类型是否相同
        /// </summary>
        /// <param name="left"></param>
        /// <param name="right"></param>
        /// <returns></returns>
        public static bool IsEqualsUnitType(string left, string right)
        {
            return left?.Replace("行政后勤", "行政工勤") == right?.Replace("行政后勤", "行政工勤");
        }

        public static bool Is(string unit, params UnitType[] types)
        {
            return !string.IsNullOrEmpty(unit) && types.Any(w => IsEqualsUnitType(w.ToString(), unit));
        }
    }

    public class AccountTypeUnit
    {
        private static string[] dic = new string[] { "科主任", "护士长" };

        /// <summary>
        /// 自动识别职称文本
        /// </summary>
        /// <param name="name"></param>
        /// <param name="defaultValue"></param>
        /// <returns></returns>
        public static string Recognition(string name, AccountUnitType defaultValue)
        {
            if (dic.Any(w => !string.IsNullOrEmpty(name) && name.Contains(w)))
                return dic.First(w => !string.IsNullOrEmpty(name) && name.Contains(w));

            return defaultValue.ToString();
        }
    }
}
