﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Performance.DtoModels
{
    /// <summary> 验证码类型 </summary>
    public enum SmsCodeType
    {
        [Description("登录")]
        Login = 1,
        [Description("其他")]
        Other = 2,
    }

    /// <summary> 用户状态 </summary>
    public enum States
    {
        [Description("登录")]
        Enabled = 1,
        [Description("其他")]
        Disabled = 2,
    }

    public enum AllotStates
    {
        /// <summary> 用户状态 </summary>
        [Description("数据未上传")]
        NoData = 0,
        /// <summary> 数据已上传 </summary>
        [Description("数据已上传")]
        FileUploaded = 1,
        /// <summary> 正在校验数据 </summary>
        [Description("正在校验数据")]
        InCheckData = 2,
        /// <summary> 数据验证通过 </summary>
        [Description("数据验证通过")]
        CheckPass = 3,
        /// <summary> 数据错误 </summary>
        [Description("数据错误")]
        CheckFail = 4,
        /// <summary> 正在生成绩效 </summary>
        [Description("正在生成绩效")]
        InGenerate = 5,
        /// <summary> 绩效结果解析成功 </summary>
        [Description("数据验证通过")]
        GenerateSucceed = 6,
        /// <summary> 绩效解析失败 </summary>
        [Description("绩效解析失败")]
        GenerateFail = 7,
        /// <summary> 归档 </summary>
        [Description("归档")]
        Archive = 8,
    }
}
