﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace Performance.DtoModels
{
    public enum ExcelVersion
    {
        xlsx,
        xls
    }

    public enum SheetType
    {
        /// <summary> 无法识别 </summary>
        [Description("无法识别")]
        Unidentifiable = 1,
        /// <summary> 医院人员名单 </summary>
        [Description("医院人员名单")]
        Employee = 2,
        /// <summary> 收入 </summary>
        [Description("收入")]
        Income = 3,
        /// <summary> 其他收入 </summary>
        [Description("其他收入")]
        OtherIncome = 4,
        /// <summary> 支出 </summary>
        [Description("支出")]
        Expend = 5,
        /// <summary> 加班 </summary>
        [Description("加班")]
        Overtime = 6,
        /// <summary> 工作量 </summary>
        [Description("工作量")]
        Workload = 7,
        /// <summary> 特殊核算单元 </summary>
        [Description("特殊核算单元")]
        SpecialUnit = 8,
        /// <summary> 临床科室医护绩效测算基础 </summary>
        [Description("临床科室医护绩效测算基础")]
        AccountBasic = 9,

        /// <summary> 科室经济核算汇总表 </summary>
        [Description("科室经济核算汇总表")]
        ComputeEconomic = 10,
        /// <summary> 医生工作量计算 </summary>
        [Description("医生工作量计算")]
        ComputeDoctorWorkload = 11,
        /// <summary> 护士工作量计算 </summary>
        [Description("护士工作量计算")]
        ComputeNurseWorkload = 12,
        /// <summary> 临床科室医生绩效测算表 </summary>
        [Description("临床科室医生绩效测算表")]
        ComputeDoctorAccount = 13,
        /// <summary> 临床科室护士绩效测算表 </summary>
        [Description("临床科室护士绩效测算表")]
        ComputeNurseAccount = 14,
    }

    /// <summary>
    /// 绩效类型 
    /// </summary>
    //public enum PerformanceType
    //{
    //    /// <summary>  </summary>
    //    [Description("")]
    //    Null = 0,

    //    /// <summary> 绩效基数临床科室主任(专门用来计算科主任绩效，由此产生=>>临床科室主任人均绩效)</summary>
    //    [Description("绩效基数临床科室主任")]
    //    StandardDirector = 1,
    //    /// <summary> 绩效基数临床科室副主任(专门用来计算科主任绩效，由此产生=>>临床科室副主任人均绩效) </summary>
    //    [Description("绩效基数临床科室副主任")]
    //    StandardDeputyDirector = 2,
    //    /// <summary> 绩效基数临床科室护士长(专门用来计算科主任绩效，由此产生=>>临床科室护士长人均绩效) </summary>
    //    [Description("绩效基数临床科室护士长")]
    //    StandardNurse = 3,
    //    /// <summary> 绩效基数医技科室主任(专门用来计算科主任绩效，由此产生=>>医技科室主任人均绩效) </summary>
    //    [Description("绩效基数医技科室主任")]
    //    StandardDirectorYJ = 14,

    //    /// <summary> 临床科室主任人均绩效 (绩效标准取 科室主任人均绩效) </summary>
    //    [Description("临床科室主任人均绩效")]
    //    ReferenceDirector = 4,
    //    /// <summary> 临床科室中层人均绩效 (绩效标准取 科室主任/护士长/科室副主任/医技主任 平均值) </summary>
    //    [Description("临床科室中层人均绩效")]
    //    ReferenceDirectorAvg = 5,

    //    /// <summary> 临床科室护士长人均绩效 (绩效标准取 护士长 平均值)</summary>
    //    [Description("临床科室护士长人均绩效")]
    //    ReferenceHeadNurse = 7,
    //    /// <summary> 临床科室副主任人均绩效 </summary>
    //    [Description("临床科室副主任人均绩效")]
    //    ReferenceDeputyDirector = 8,
    //    /// <summary> 临床科室医生人均绩效 </summary>
    //    [Description("临床科室医生人均绩效")]
    //    ReferenceDoctor = 9,
    //    /// <summary> 临床科室护士人均绩效 </summary>
    //    [Description("临床科室护士人均绩效")]
    //    ReferenceNurse = 10,
    //    /// <summary> 行政工勤人均绩效 </summary>
    //    [Description("行政工勤人均绩效")]
    //    LogisticsWorker = 11,
    //    /// <summary> 行政中层人均绩效 </summary>
    //    [Description("行政中层人均绩效")]
    //    MiddleManager = 12,
    //    /// <summary> 行政高层人均绩效 </summary>
    //    [Description("行政高层人均绩效")]
    //    TopManager = 13,
    //}

    /// <summary>
    /// 核算单元类型
    /// </summary>
    public enum AccountUnitType
    {
        /// <summary>  </summary>
        [Description("")]
        Null = 1,
        /// <summary> 临床科室 </summary>
        [Description("临床科室")]
        临床科室 = 2,
        /// <summary> 临床科室 </summary>
        [Description("医技科室")]
        医技科室 = 3,
        /// <summary> 行政高层 </summary>
        [Description("行政高层")]
        行政高层 = 4,
        /// <summary> 临床科室 </summary>
        [Description("行政中层")]
        行政中层 = 5,
        /// <summary> 临床科室 </summary>
        [Description("行政工勤")]
        行政工勤 = 6,
    }

    public enum PerforType
    {
        [Description("临床科室主任人均绩效")]
        临床主任,
        [Description("临床科室副主任人均绩效")]
        临床副主任,
        [Description("医技科室主任人均绩效")]
        医技主任,
        [Description("医技科室副主任人均绩效")]
        医技副主任,
        [Description("护士长人均绩效")]
        护士长,
        [Description("护士人均绩效")]
        护士,
        [Description("临床主任护士长平均")]
        临床主任护士长平均,
        [Description("临床医生人均绩效")]
        临床医生,
        [Description("医技医生人均绩效")]
        医技医生,
        [Description("行政高层人均绩效")]
        行政高层,
        [Description("行政中层人均绩效")]
        行政中层,
        [Description("行政工勤人均绩效")]
        行政工勤,
    }

    /// <summary>
    /// 当前枚举为效率绩效、规模绩效中系数中文名称
    /// 对应表cof_director中JobTitle 全文字匹配
    /// </summary>
    public enum DirectorType
    {
        临床科室主任,
        临床科室副主任,
        医技科室主任,
        医技科室副主任,
        临床科室护士长,
    }
}
