﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using FluentValidation.AspNetCore;
using Microsoft.AspNetCore.Mvc;
using Microsoft.AspNetCore.StaticFiles;
using Microsoft.Extensions.Logging;
using Microsoft.Extensions.Options;
using Performance.DtoModels;
using Performance.DtoModels.AppSettings;
using Performance.Infrastructure;
using Performance.Services;

namespace Performance.Extract.Api.Controllers
{
    [Route("api/[controller]")]
    public class ExtractController : Controller
    {
        private readonly ExtractService extractService;
        private readonly HospitalService hospitalService;
        private readonly WebapiUrl url;
        private readonly ILogger<ExtractController> logger;
        public ExtractController(ExtractService extractService, HospitalService hospitalService,
            IOptions<WebapiUrl> url, ILogger<ExtractController> logger)
        {
            this.extractService = extractService;
            this.hospitalService = hospitalService;
            this.url = url.Value;
            this.logger = logger;
        }

        [HttpPost]
        [Route("index")]
        public void Index([FromBody]AllotRequest request)
        {
            var token = Guid.NewGuid().ToString("N");
            logger.LogInformation(token + ",开始提取数据，请求参数：" + JsonHelper.Serialize(request));
            var hospital = hospitalService.GetHopital(request.HospitalId.Value);
            var filepath = extractService.ExtractData(request.ID, request.Mail, hospital);
            if (!string.IsNullOrEmpty(filepath) && FileHelper.IsExistFile(filepath))
            {
                int i = 1;
                while (i <= 5)
                {
                    string retJson = HttpHelper.HttpClient(url.ImportFile + $"?allotId={request.ID}&hospitalId={hospital.ID}", filepath);

                    logger.LogInformation(retJson);
                    var ret = JsonHelper.Deserialize<ApiResponse>(retJson);
                    if ((int)ret.State == 1)
                        break;
                    i++;
                }
            }
            logger.LogInformation(token + ",提取结束，请求参数：" + JsonHelper.Serialize(request));
        }
    }
}