﻿using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services.AllotCompute
{

    /// <summary>
    /// 绩效标准数据
    /// </summary>
    public class BaiscNormService : IAutoInjection
    {
        /// <summary>
        /// 绩效标准计算 主任 副主任 护士长
        /// </summary>
        /// <param name="computes"></param>
        /// <returns></returns>
        public List<res_baiscnorm> ComputeAvg(List<res_baiscnorm> baiscnormList, List<ComputeResult> computes, List<im_employee> empolyeeList)
        {
            var keyList = new[]
            {
                //绩效基数平均值项目
                new { type = AccountUnitType.临床科室, reference = PerforType.临床主任 },
                new { type = AccountUnitType.临床科室, reference = PerforType.临床副主任 },
                new { type = AccountUnitType.临床科室, reference = PerforType.护士长 },
                new { type = AccountUnitType.医技科室, reference = PerforType.医技主任 },
                new { type = AccountUnitType.医技科室, reference = PerforType.医技副主任 },
            };
            foreach (var item in keyList)
            {
                var count = empolyeeList.Count(t => t.AccountType == item.type.ToString() && t.FitPeople == EnumHelper.GetDescription(item.reference));
                if (count > 0)
                {
                    var dataList = computes.Where(t => t.AccountType == item.type.ToString() && t.FitPeople == EnumHelper.GetDescription(item.reference));
                    var baiscnorm = new res_baiscnorm
                    {
                        PositionName = EnumHelper.GetDescription(item.reference),
                        TotelNumber = count,
                        TotelValue = dataList.Sum(t => t.GiveFee),
                        AvgValue = dataList.Sum(t => t.GiveFee) / count
                    };
                    baiscnormList.Add(baiscnorm);
                }
            }
            return baiscnormList;
        }

        /// <summary>
        /// 院领导、行政中层、行政工勤 平均值
        /// </summary>
        /// <param name="computes"></param>
        /// <returns></returns>
        public List<res_baiscnorm> ComputeOtherAvg(List<res_baiscnorm> baiscnormList, List<ComputeResult> computes, List<im_employee> empolyeeList)
        {
            var keyList = new[]
            {
                //行政绩效平均值项目
                new { type = AccountUnitType.行政中层, reference = PerforType.行政中层 },
                new { type = AccountUnitType.行政工勤, reference = PerforType.行政工勤 },
                new { type = AccountUnitType.行政高层, reference = PerforType.行政高层 },
            };

            foreach (var item in keyList)
            {
                var count = empolyeeList.Count(t => t.AccountType == item.type.ToString());
                if (count > 0)
                {
                    var dataList = computes.Where(t => t.AccountType == item.type.ToString());
                    var baiscnorm = new res_baiscnorm
                    {
                        PositionName = EnumHelper.GetDescription(item.reference),
                        TotelNumber = count,
                        TotelValue = dataList.Sum(t => t.GiveFee),
                        AvgValue = dataList.Sum(t => t.GiveFee) / count
                    };
                    baiscnormList.Add(baiscnorm);
                }
            }
            return baiscnormList;
        }

        /// <summary>
        /// 获取绩效标准基础值
        /// </summary>
        /// <param name="baiscnorms"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        public decimal? GetBaiscNorm(List<res_baiscnorm> baiscnorms, PerforType type)
        {
            decimal? result = null;
            if (type == PerforType.临床主任护士长平均)
            {
                var lczrValue = baiscnorms.FirstOrDefault(t => t.PositionName == EnumHelper.GetDescription(PerforType.临床主任))?.AvgValue;
                var hszValue = baiscnorms.FirstOrDefault(t => t.PositionName == EnumHelper.GetDescription(PerforType.护士长))?.AvgValue;
                result = ((lczrValue ?? 0) + (hszValue ?? 0)) / 2;
            }
            else
            {
                result = baiscnorms.FirstOrDefault(t => t.PositionName == EnumHelper.GetDescription(type))?.AvgValue;
            }

            if (result.HasValue)
                result = Math.Round(result.Value, 4);
            return result;
        }

        /// <summary>
        /// 获取临床医生护士平均绩效
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public List<res_baiscnorm> DocterNurseBaiscnorm(List<res_baiscnorm> baiscnormList, List<PerSheet> list)
        {
            // 护士
            var sheetNurse = list.FirstOrDefault(t => t.SheetType == SheetType.ComputeNurseAccount);
            var perdataNurse = sheetNurse.PerData.Select(t => (PerDataAccountNurse)t);
            var baiscnormNurse = new res_baiscnorm
            {
                PositionName = EnumHelper.GetDescription(PerforType.护士),
                TotelNumber = perdataNurse.Sum(t => t.Number),
                TotelValue = perdataNurse.Sum(t => t.PerforTotal),
                AvgValue = perdataNurse.Sum(t => t.PerforTotal) / perdataNurse.Sum(t => t.Number)
            };
            baiscnormList.Add(baiscnormNurse);

            // 医生
            var sheetDocter = list.FirstOrDefault(t => t.SheetType == SheetType.ComputeDoctorAccount);
            var perdataDocter = sheetDocter.PerData.Select(t => (PerDataAccountDoctor)t);
            var baiscnormDocter = new res_baiscnorm
            {
                PositionName = EnumHelper.GetDescription(PerforType.临床医生),
                TotelNumber = perdataDocter.Sum(t => t.Number),
                TotelValue = perdataDocter.Sum(t => t.PerforTotal),
                AvgValue = perdataDocter.Sum(t => t.PerforTotal) / perdataDocter.Sum(t => t.Number)
            };
            baiscnormList.Add(baiscnormDocter);

            return baiscnormList;
        }
    }
}
