﻿using NPOI.SS.UserModel;
using Performance.DtoModels;
using Performance.Infrastructure;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    public class PerSheetDataReadSpecialUnit : IPerSheetDataRead
    {
        public PerSheetPoint Point => new PerSheetPoint
        {
            HeaderFirstRowNum = 1,
            HeaderLastRowNum = 1,
            HeaderFirstCellNum = 0,
            DataFirstRowNum = 2,
        };

        public List<IPerData> ReadData(ISheet sheet, List<PerHeader> perHeader)
        {
            List<IPerData> dataList = new List<IPerData>();
            // 特殊科室多科室聚合，合并时保留科室名称
            string lastAccount = "";
            for (int r = Point.DataFirstRowNum.Value; r < sheet.LastRowNum + 1; r++)
            {
                var row = sheet.GetRow(r);
                if (row == null) continue;

                var accountingUnit = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "科室").PointCell)?.ToString();
                if (string.IsNullOrEmpty(accountingUnit))
                    accountingUnit = lastAccount;
                PerDataSpecialUnit specialUnit = new PerDataSpecialUnit
                {
                    RowNumber = r,
                    AccountingUnit = accountingUnit,
                    Department = accountingUnit,
                    QuantitativeIndicators = row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "量化指标").PointCell)?.ToString(),
                    Quantity = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "数量").PointCell)?.ToString()),
                    QuantitativeIndicatorsValue = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "量化指标绩效分值").PointCell)?.ToString()),
                };
                //相同科室只取以下项目第一次出现的值
                if (accountingUnit != lastAccount)
                {
                    specialUnit.Number = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "人数").PointCell)?.ToString());
                    specialUnit.ScoringAverage = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "考核得分率").PointCell)?.ToString());
                    specialUnit.OtherPerfor = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "其他绩效").PointCell)?.ToString());
                    specialUnit.Punishment = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "医院奖罚").PointCell)?.ToString());
                    specialUnit.Adjust = ConvertHelper.To<decimal?>(row.GetCell(perHeader.FirstOrDefault(p => p.CellValue == "调节系数").PointCell)?.ToString());
                }
                dataList.Add(specialUnit);
                //合并单元格科室名称补全
                lastAccount = specialUnit.AccountingUnit;
            }

            return dataList;
        }
    }
}
