﻿using AutoMapper;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Performance.Services
{
    /// <summary>
    /// 提供sheet数据查询服务
    /// </summary>
    public class SheetSevice : IAutoInjection
    {
        private PerforPerallotRepository _perforAllotRepository;
        private PerforPersheetRepository _perforImSheetRepository;
        private PerforImdataRepository _perforImDataRepository;
        private PerforImheaderRepository _perforImHeaderRepository;
        private PerforImemployeeRepository _perforImEmployeeRepository;
        private PerforImaccountbasicRepository _perforImaccountbasicRepository;
        private PerforResaccountdoctorRepository _perforImaccountdoctorRepository;
        private PerforResaccountnurseRepository _perforImaccountnurseRepository;
        private PerforImspecialunitRepository _perforImspecialunitRepository;

        public SheetSevice(PerforPerallotRepository perforAllotRepository,
            PerforPersheetRepository perforImSheetRepository,
            PerforImdataRepository perforImDataRepository,
            PerforImheaderRepository perforImHeaderRepository,
            PerforImemployeeRepository perforImEmployeeRepository,
            PerforImaccountbasicRepository perforImaccountbasicRepository,
            PerforResaccountdoctorRepository perforImaccountdoctorRepository,
            PerforResaccountnurseRepository perforImaccountnurseRepository,
            PerforImspecialunitRepository perforImspecialunitRepository)
        {
            _perforAllotRepository = perforAllotRepository;
            _perforImSheetRepository = perforImSheetRepository;
            _perforImDataRepository = perforImDataRepository;
            _perforImHeaderRepository = perforImHeaderRepository;
            _perforImEmployeeRepository = perforImEmployeeRepository;
            _perforImaccountdoctorRepository = perforImaccountdoctorRepository;
            _perforImaccountnurseRepository = perforImaccountnurseRepository;
            _perforImaccountbasicRepository = perforImaccountbasicRepository;
            _perforImspecialunitRepository = perforImspecialunitRepository;
        }

        /// <summary>
        /// sheet 列表查询
        /// </summary>
        /// <param name="allotID"></param>
        /// <returns></returns>
        public List<SheetResponse> SheetList(int allotID, int source)
        {
            var allot = _perforAllotRepository.GetEntity(t => t.ID == allotID);
            if (allot == null)
                throw new PerformanceException("参数allotid无效");
            int[] arr = new int[] { 1, 2 };
            if (!arr.Contains(source))
                throw new PerformanceException("参数source无效");

            var sheetList = _perforImSheetRepository.GetEntities(t => t.AllotID == allotID && t.Source == source);
            return Mapper.Map<List<SheetResponse>>(sheetList);
        }

        /// <summary>
        /// sheet数据查询
        /// </summary>
        /// <param name="sheetID"></param>
        /// <returns></returns>
        public SheetExportResponse SheetExport(int sheetID)
        {
            var sheet = _perforImSheetRepository.GetEntity(t => t.ID == sheetID);
            if (sheet == null)
                throw new PerformanceException("参数sheetid无效");

            SheetExportResponse response = new SheetExportResponse(sheet.ID, sheet.SheetName, sheet.SheetType.Value);
            if (sheet.SheetType == (int)SheetType.Employee)
            {
                EmployeeExport(sheetID, response);
            }
            else if (sheet.SheetType == (int)SheetType.SpecialUnit)
            {
                SpecialUnitExport(sheetID, response);
            }
            else if (sheet.SheetType == (int)SheetType.AccountBasic)
            {
                AccountBaiscExport(sheetID, response);
            }
            else if (sheet.SheetType == (int)SheetType.ComputeDoctorAccount)
            {
                AccountDoctorExport(sheetID, response);
            }
            else if (sheet.SheetType == (int)SheetType.ComputeNurseAccount)
            {
                AccountNurseExport(sheetID, response);
            }
            else
            {
                CommonExport(sheetID, response);
            }

            return response;
        }

        private void SpecialUnitExport(int sheetID, SheetExportResponse response)
        {
            var list = _perforImspecialunitRepository.GetEntities(t => t.SheetID == sheetID);

            if (list != null && list.Count() > 0)
            {
                var row = new Row(0);
                row.Data.Add(new Cell(1, "核算单元", 1, 1, false, false));
                row.Data.Add(new Cell(2, "科室", 1, 1, false, false));
                row.Data.Add(new Cell(3, "人数", 1, 1, false, true));
                row.Data.Add(new Cell(4, "量化指标", 1, 1, false, true));
                row.Data.Add(new Cell(5, "数量", 1, 1, false, true));
                row.Data.Add(new Cell(6, "量化指标绩效分值", 1, 1, false, true));
                row.Data.Add(new Cell(7, "考核得分率", 1, 1, false, true));
                row.Data.Add(new Cell(8, "其他绩效", 1, 1, false, true));
                row.Data.Add(new Cell(9, "医院奖罚", 1, 1, false, true));
                row.Data.Add(new Cell(10, "调节系数", 1, 1, false, true));
                response.Header.Add(row);
                for (int i = 0; i < list.Count(); i++)
                {
                    var item = list.ElementAt(i);
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, item.AccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.Department, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(3, item.Number, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(4, item.QuantitativeIndicators, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.Quantity, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.QuantitativeIndicatorsValue, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, item.ScoringAverage, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, item.OtherPerfor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, item.Punishment, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, item.Adjust, 1, 1, false, true));
                    response.Row.Add(rowbody);
                }
            }
        }

        private void CommonExport(int sheetID, SheetExportResponse response)
        {
            var headList = _perforImHeaderRepository.GetEntities(t => t.SheetID == sheetID)?.OrderBy(t => t.PointCell);
            if (headList == null) return;

            var dataList = _perforImDataRepository.GetEntities(t => t.SheetID == sheetID);
            if (dataList == null || dataList.Count == 0) return;



            List<string> sheetNames = new List<string> {
                "1.1.1 门诊就诊收入","1.1.2 门诊执行收入","1.2.1 住院就诊收入",
                "1.2.2 住院执行收入","1.3.1 转入ICU就诊收入","1.3.2 转入ICU执行收入",
            };
            //添加系数值
            string sheetName = _perforImSheetRepository.GetEntity(t => t.ID == sheetID).SheetName;
            var factorhead = new Row(0);
            if (sheetName.Contains("工作量绩效测算表"))
            {
                factorhead.Data.Add(new Cell(0, "单元工作量绩效标准：", 1, 2, false, false));
                response = AddFactor(response, factorhead, headList.ToList(), dataList, sheetName);
            }
            else if (sheetNames.Contains(sheetName))
            {
                factorhead.Data.Add(new Cell(0, "护理组分割比例", 1, 3, false, false));
                response = AddFactor(response, factorhead, headList.ToList(), dataList, "护理组");
                var factorhead1 = new Row(1);
                factorhead1.Data.Add(new Cell(0, "医生组分割比例", 1, 3, false, false));
                response = AddFactor(response, factorhead1, headList.ToList(), dataList, "医生组");
            }



            //创建列头行
            var rowhead = new Row(response.Header.Count());
            response.Header.Add(rowhead);
            foreach (var header in headList.Where(t => !t.ParentID.HasValue || t.ParentID.Value == 0))
            {
                rowhead.Data.Add(new Cell(header.PointCell.Value, header.CellValue, header.MergeRow.Value, header.MergeCell.Value, header.IsTotal == 1, false));
            }
            if (headList.Any(t => t.ParentID.HasValue && t.ParentID.Value > 0))
            {
                var rowhead2 = new Row(response.Header.Count());
                response.Header.Add(rowhead2);
                foreach (var header in headList.Where(t => t.ParentID.HasValue && t.ParentID.Value > 0))
                {
                    rowhead2.Data.Add(new Cell(header.PointCell.Value, header.CellValue, header.MergeRow.Value, header.MergeCell.Value, header.IsTotal == 1, false));
                }
            }
            List<im_header> headers = new List<im_header>();
            foreach (var head in headList)
            {
                if (!headList.Any(t => t.ParentID == head.ID))
                    headers.Add(head);
            }

            //创建数据行
            Row rowbody = null;
            foreach (var rowNumber in dataList.Select(t => t.RowNumber).OrderBy(t => t).Distinct())
            {
                foreach (var head in headers)
                {
                    if (rowbody == null || rowbody.Rownumber != rowNumber)
                    {
                        rowbody = new Row(rowNumber ?? 0);
                        response.Row.Add(rowbody);
                    }
                    if (head.CellValue.Contains("核算单元"))
                    {
                        if (head.CellValue.Contains("医生组"))
                        {
                            var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber && t.UnitType == 1)?.AccountingUnit;
                            rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                        }
                        else if (head.CellValue.Contains("护理组"))
                        {
                            var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber && t.UnitType == 2)?.AccountingUnit;
                            rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                        }
                        else
                        {
                            var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber)?.AccountingUnit;
                            rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                        }
                    }
                    else if (head.CellValue.Contains("科室名称"))
                    {
                        var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber).Department;
                        rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                    }
                    else if (head.CellValue.Contains("备注"))
                    {
                        var value = dataList.FirstOrDefault(t => t.RowNumber == rowNumber).Remark;
                        rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, false, false));
                    }
                    else if (!rowbody.Data.Any(t => t.PointCell == head.PointCell))
                    {
                        var data = dataList.FirstOrDefault(t => t.RowNumber == rowNumber && t.SignID == head.SignID);
                        var value = data?.CellValue;
                        if (value.HasValue && value.Value > 0)
                            rowbody.Data.Add(new Cell(head.PointCell.Value, value, 1, 1, data.IsTotal == 1, true, data.Annotation));
                    }
                }
            }
        }

        private void AccountNurseExport(int sheetID, SheetExportResponse response)
        {
            var list = _perforImaccountnurseRepository.GetEntities(t => t.SheetID == sheetID);

            if (list != null && list.Count() > 0)
            {
                var row = new Row(0);
                row.Data.Add(new Cell(1, "核算单元", 1, 1, false, false));
                row.Data.Add(new Cell(2, "核算单元护士数量", 1, 1, false, true));
                row.Data.Add(new Cell(3, "医生基础系数", 1, 1, false, true));
                row.Data.Add(new Cell(4, "倾斜系数", 1, 1, false, true));
                row.Data.Add(new Cell(5, "其他绩效1", 1, 1, false, true));
                row.Data.Add(new Cell(6, "其他绩效2", 1, 1, false, true));
                row.Data.Add(new Cell(7, "医院奖罚", 1, 1, false, true));
                row.Data.Add(new Cell(8, "考核对分率", 1, 1, false, true));
                row.Data.Add(new Cell(9, "调节系数", 1, 1, false, true));
                row.Data.Add(new Cell(10, "科室业绩", 1, 1, false, true));
                row.Data.Add(new Cell(11, "业绩绩效", 1, 1, false, true));
                row.Data.Add(new Cell(12, "工作量绩效", 1, 1, false, true));
                row.Data.Add(new Cell(13, "绩效合计", 1, 1, false, true));
                row.Data.Add(new Cell(14, "人均绩效", 1, 1, false, true));
                row.Data.Add(new Cell(15, "实发绩效", 1, 1, false, true));

                response.Header.Add(row);
                for (int i = 0; i < list.Count(); i++)
                {
                    var item = list.ElementAt(i);
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, item.AccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.Number, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(3, item.BasicFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(4, item.SlopeFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.OtherPerfor1, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.OtherPerfor2, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, item.Extra, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, item.ScoringAverage, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, item.AdjustFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, item.Income, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(11, item.PerforFee, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(12, item.WorkloadFee, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(13, item.PerforTotal, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(14, item.Avg, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(15, item.RealGiveFee, 1, 1, false, true));
                    response.Row.Add(rowbody);
                }
            }
        }

        private void AccountDoctorExport(int sheetID, SheetExportResponse response)
        {
            var list = _perforImaccountdoctorRepository.GetEntities(t => t.SheetID == sheetID);

            if (list != null && list.Count() > 0)
            {
                var row = new Row(0);
                row.Data.Add(new Cell(1, "核算单元", 1, 1, false, false));
                row.Data.Add(new Cell(2, "核算单元医生数量", 1, 1, false, true));
                row.Data.Add(new Cell(3, "医生基础系数", 1, 1, false, true));
                row.Data.Add(new Cell(4, "倾斜系数", 1, 1, false, true));
                row.Data.Add(new Cell(5, "其他绩效1", 1, 1, false, true));
                row.Data.Add(new Cell(6, "其他绩效2", 1, 1, false, true));
                row.Data.Add(new Cell(7, "医院奖罚", 1, 1, false, true));
                row.Data.Add(new Cell(8, "考核对分率", 1, 1, false, true));
                row.Data.Add(new Cell(9, "调节系数", 1, 1, false, true));
                row.Data.Add(new Cell(10, "科室业绩", 1, 1, false, true));
                row.Data.Add(new Cell(11, "业绩绩效", 1, 1, false, true));
                row.Data.Add(new Cell(12, "工作量绩效", 1, 1, false, true));
                row.Data.Add(new Cell(13, "绩效合计", 1, 1, false, true));
                row.Data.Add(new Cell(14, "人均绩效", 1, 1, false, true));
                row.Data.Add(new Cell(15, "实发绩效", 1, 1, false, true));

                response.Header.Add(row);
                for (int i = 0; i < list.Count(); i++)
                {
                    var item = list.ElementAt(i);
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, item.AccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.Number, 1, 1, false, true));

                    rowbody.Data.Add(new Cell(3, item.BasicFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(4, item.SlopeFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.OtherPerfor1, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.OtherPerfor2, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, item.Extra, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, item.ScoringAverage, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, item.AdjustFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, item.Income, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(11, item.PerforFee, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(12, item.WorkloadFee, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(13, item.PerforTotal, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(14, item.Avg, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(15, item.RealGiveFee, 1, 1, false, true));

                    response.Row.Add(rowbody);
                }
            }
        }

        private void AccountBaiscExport(int sheetID, SheetExportResponse response)
        {
            var list = _perforImaccountbasicRepository.GetEntities(t => t.SheetID == sheetID);

            if (list != null && list.Count() > 0)
            {
                var row1 = new Row(0);
                row1.Data.Add(new Cell(1, "核算单元", 2, 1, false, false));
                row1.Data.Add(new Cell(2, "科室", 2, 1, false, false));
                row1.Data.Add(new Cell(3, "医生组", 1, 8, false, false));
                row1.Data.Add(new Cell(11, "护士组", 1, 8, false, false));
                response.Header.Add(row1);

                var row2 = new Row(1);
                row2.Data.Add(new Cell(3, "核算单元医生数量", 1, 1, false, false));
                row2.Data.Add(new Cell(4, "医生基础系数", 1, 1, false, false));
                row2.Data.Add(new Cell(5, "倾斜系数", 1, 1, false, false));
                row2.Data.Add(new Cell(6, "其他绩效1", 1, 1, false, false));
                row2.Data.Add(new Cell(7, "其他绩效2", 1, 1, false, false));
                row2.Data.Add(new Cell(8, "医院奖罚", 1, 1, false, false));
                row2.Data.Add(new Cell(9, "考核对分率", 1, 1, false, false));
                row2.Data.Add(new Cell(10, "调节系数", 1, 1, false, false));

                row2.Data.Add(new Cell(11, "核算单元护士数量", 1, 1, false, false));
                row2.Data.Add(new Cell(12, "医生基础系数", 1, 1, false, false));
                row2.Data.Add(new Cell(13, "倾斜系数", 1, 1, false, false));
                row2.Data.Add(new Cell(14, "其他绩效1", 1, 1, false, false));
                row2.Data.Add(new Cell(15, "其他绩效2", 1, 1, false, false));
                row2.Data.Add(new Cell(16, "医院奖罚", 1, 1, false, false));
                row2.Data.Add(new Cell(17, "考核对分率", 1, 1, false, false));
                row2.Data.Add(new Cell(18, "调节系数", 1, 1, false, false));

                response.Header.Add(row2);
                for (int i = 0; i < list.Count(); i++)
                {
                    var item = list.ElementAt(i);
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, item.AccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.Department, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(3, item.DoctorNumber, 1, 1, false, true));

                    rowbody.Data.Add(new Cell(4, item.DoctorBasicFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.DoctorSlopeFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.DoctorOtherPerfor1, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, item.DoctorOtherPerfor2, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, item.DoctorExtra, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, item.DoctorScoringAverage, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, item.DoctorAdjustFactor, 1, 1, false, true));

                    rowbody.Data.Add(new Cell(11, item.NurseNumber, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(12, item.NurseBasicFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(13, item.NurseSlopeFactor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(14, item.NurseOtherPerfor1, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(15, item.NurseOtherPerfor2, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(16, item.NurseExtra, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(17, item.NurseScoringAverage, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(18, item.NurseAdjustFactor, 1, 1, false, true));
                    response.Row.Add(rowbody);
                }
            }
        }

        private void EmployeeExport(int sheetID, SheetExportResponse response)
        {
            var employeeList = _perforImEmployeeRepository.GetEntities(t => t.SheetID == sheetID).OrderBy(t => t.RowNumber);

            if (employeeList != null && employeeList.Count() > 0)
            {
                var row = new Row(0);
                row.Data.Add(new Cell(1, "核算单元", 1, 1, false, false));
                row.Data.Add(new Cell(2, "科室", 1, 1, false, false));
                row.Data.Add(new Cell(3, "医生姓名", 1, 1, false, true));
                row.Data.Add(new Cell(4, "职称", 1, 1, false, true));
                row.Data.Add(new Cell(5, "绩效基数核算参考对象", 1, 1, false, true));
                row.Data.Add(new Cell(6, "岗位系数", 1, 1, false, true));
                row.Data.Add(new Cell(7, "参加工作时间", 1, 1, false, true));
                row.Data.Add(new Cell(8, "考核得分率", 1, 1, false, true));
                row.Data.Add(new Cell(9, "出勤率", 1, 1, false, true));
                row.Data.Add(new Cell(10, "核算单元医生数", 1, 1, false, true));
                row.Data.Add(new Cell(11, "工作量绩效", 1, 1, false, true));
                row.Data.Add(new Cell(12, "其他绩效", 1, 1, false, true));
                row.Data.Add(new Cell(13, "医院奖罚", 1, 1, false, true));
                row.Data.Add(new Cell(14, "调节系数", 1, 1, false, true));
                row.Data.Add(new Cell(15, "发放系数", 1, 1, false, true));
                response.Header.Add(row);
                for (int i = 0; i < employeeList.Count(); i++)
                {
                    var item = employeeList.ElementAt(i);
                    var workTime = item.WorkTime != null ? ((DateTime)item.WorkTime).ToString("yyyy-MM-dd") : "";
                    var rowbody = new Row(i);
                    rowbody.Data.Add(new Cell(1, item.AccountingUnit, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(2, item.Department, 1, 1, false, false));
                    rowbody.Data.Add(new Cell(3, item.DoctorName, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(4, item.JobTitle, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(5, item.FitPeople, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(6, item.PostCoefficient, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(7, workTime, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(8, item.ScoreAverageRate, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(9, item.Attendance, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(10, item.PeopleNumber, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(11, item.Workload, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(12, item.OtherPerfor, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(13, item.Punishment, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(14, item.Adjust, 1, 1, false, true));
                    rowbody.Data.Add(new Cell(15, item.Grant, 1, 1, false, true));
                    response.Row.Add(rowbody);
                }
            }
        }

        /// <summary>
        /// 添加系数值
        /// </summary>
        /// <param name="response"></param>
        /// <param name="row"></param>
        /// <param name="headList"></param>
        /// <param name="dataList"></param>
        /// <param name="type"></param>
        /// <returns></returns>
        private SheetExportResponse AddFactor(SheetExportResponse response, Row row, List<im_header> headList, List<im_data> dataList, string type)
        {
            int unitType = type.Contains("医生") ? 1 : 2;
            response.Header.Add(row);
            if (headList.Any(t => t.ParentID.HasValue && t.ParentID.Value > 0))
            {
                foreach (var header in headList.Where(t => t.ParentID.HasValue && t.ParentID.Value > 0))
                {
                    var factor = _perforImDataRepository.GetEntities(t => t.AllotID == header.AllotID && t.SheetID == header.SheetID && t.IsFactor == 1
                                 && t.TypeName == header.CellValue && t.UnitType == unitType);
                    decimal? value = factor != null ? factor.FirstOrDefault().FactorValue : null;
                    row.Data.Add(new Cell(header.PointCell.Value, value, header.MergeRow.Value, header.MergeCell.Value, header.IsTotal == 1, false));
                }
            }
            else
            {
                foreach (var header in headList.Where(t => !t.ParentID.HasValue || t.ParentID.Value == 0))
                {
                    if (header.CellValue != "核算单元（医生组）" && header.CellValue != "核算单元（护理组）" && header.CellValue != "科室名称")
                    {
                        var factor = _perforImDataRepository.GetEntities(t => t.AllotID == header.AllotID && t.SheetID == header.SheetID && t.IsFactor == 1
                                     && t.TypeName == header.CellValue && t.UnitType == unitType);
                        decimal? value = factor != null ? factor.FirstOrDefault().FactorValue : null;
                        row.Data.Add(new Cell(header.PointCell.Value, value, header.MergeRow.Value, header.MergeCell.Value, header.IsTotal == 1, false));
                    }
                }
            }
            return response;
        }
    }
}
