﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Text;

namespace Performance.DtoModels
{
    public class DrugpropRequest
    {
        public int ID { get; set; }

        public int HospitalId { get; set; }

        public int AllotID { get; set; }
        /// <summary>
        /// 药占比最大范围（小于）
        /// </summary>
        public decimal MaxRange { get; set; }
        /// <summary>
        /// 药占比最小范围（大于等于）
        /// </summary>
        public decimal MinRange { get; set; }
        /// <summary>
        /// 药占比对应系数
        /// </summary>
        public decimal Value { get; set; }
        /// <summary>
        /// 费用名称
        /// </summary>
        public string Charge { get; set; }
        /// <summary>
        /// 费用类别
        /// </summary>
        public string ChargeType { get; set; }


        public class DrugpropRequestValidator : AbstractValidator<DrugpropRequest>
        {
            public DrugpropRequestValidator()
            {
                RuleSet("Select", () =>
                {
                    RuleFor(x => x.AllotID).NotNull().NotEmpty().GreaterThan(0);
                });

                RuleSet("Insert", () =>
                {
                    RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                    RuleFor(x => x.AllotID).NotNull().GreaterThan(0);
                });

                RuleSet("Update", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });

                RuleSet("Delete", () =>
                {
                    RuleFor(x => x.ID).NotNull().GreaterThan(0);
                });
            }
        }
    }
}
