﻿using System.Collections.Generic;
using Microsoft.AspNetCore.Mvc;
using Performance.DtoModels;
using Performance.EntityModels;
using Performance.Services;

namespace Performance.Api.Controllers
{
    /// <summary>
    /// 每月报表
    /// </summary>
    [Route("api/statistics")]
    public class StatisticsController : Controller
    {
        private readonly StatisticsService _service;

        public StatisticsController(StatisticsService service)
        {
            _service = service;
        }

        /// <summary>
        /// 查询报表信息
        /// </summary>
        /// <param name="statisticsId"></param>
        /// <param name="hospitalID"></param>
        /// <returns></returns>
        [HttpPost("info")]
        public ApiResponse<StatisticsInfoDto> GetInfo(int hospitalID, int statisticsId)
        {

            // report_statistics
            // report_statistics_selection

            return new ApiResponse<StatisticsInfoDto>(ResponseType.OK, _service.GetInfo(hospitalID, statisticsId));
        }

        /// <summary>
        /// 查询报表查询记录
        /// </summary>
        /// <param name="statisticsId"></param>
        /// <param name="hospitalID"></param>
        /// <returns></returns>
        [HttpPost("selection/record")]
        public ApiResponse<List<report_statistics_selection_record>> GetSelectionRecord(int hospitalID, int statisticsId)
        {
            return new ApiResponse<List<report_statistics_selection_record>>(ResponseType.OK, _service.GetSelectionRecord(hospitalID, statisticsId));
        }

        /// <summary>
        /// 保存报表查询记录
        /// </summary>
        /// <returns></returns>
        [HttpPost("selection/record/save")]
        public ApiResponse SaveSelectionRecord([FromBody] report_statistics_selection_record record)
        {
            return _service.SaveSelectionRecord(record);
        }

        /// <summary>
        /// 删除报表查询记录
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        [HttpPost("selection/record/delete")]
        public ApiResponse DeleteSelectionRecord(int id)
        {
            if (_service.DeleteSelectionRecord(id))
                return new ApiResponse(ResponseType.OK, "删除成功");
            else
                return new ApiResponse(ResponseType.Fail, "删除失败");
        }

        /// <summary>
        /// 查询报表结果
        /// </summary>
        /// <returns></returns>
        [HttpPost("search")]
        public ApiResponse<StatisticsQueryResultDto> Search([FromBody] StatisticsQuery query)
        {
            // 数额必须返回
            // Columns
            // 占比 判断层级结构表中是否存在公式  存在则返回
            // 权重 判断层级结构表中是否存在公式  存在则返回
            // 增降幅 判断是否是对比查询 存在则返回


            // Data
            // 判断层级结构表中是否存在数据
            //   1.使用层级表中的SQL查询数据出来
            //      层级固定插入 项目 列中（今天或明天再确定下来）
            //      数额固定插入 数额 列中
            //      带公式信息列，则把表中的公式放入即可
            //      剩余的判断则和列头相同的判断规则，插入空白数据
            //   2.否则 使用主表SQL查询数据出来
            //      横向转换结构（今天或明天再确定下来）

            // 占位符 分两种
            //  1.具有具体名称的占位符  如 @UnitType  直接替换为具体参数 
            //  2.前端传入参数，但没有具体占位的 则拼接后替换 @wh  如 @UnitType  直接替换为具体参数   

            /*
             
            SELECT SUM(VALUE) FROM report_statistics_store WHERE Category  IN ('中成药费','西药费') AND UnitType IN @UnitType AND @wh
            
            参数
            {
                "HospitalID":"12",
                "UnitType":"医生组",
                "AccoungtingUnti":"呼吸内科"
            }

            where = "";
            //  先循环  参数
            判断是否存在  存在则替换  不存在 则 拼接到变量
                1. HospitalID  >> 拼接 where = "HospitalID = 12"
                2. UnitType  >> 替换  where = "HospitalID = 12"
                3. AccoungtingUnti  >> 拼接  where = "HospitalID = 12  AND AccoungtingUnti IN ('呼吸内科') "

            替换@wh = where


            
            SELECT SUM(VALUE) FROM report_statistics_store WHERE Category  IN ('中成药费','西药费') AND UnitType IN ('医生组') AND HospitalID = 12  AND AccoungtingUnti IN ('呼吸内科')


             */


            // 取出对应SQL（多条）
            // 循环执行
            // { "数额" , "SQL"。  } >> { "数额" , "23" }


            return new ApiResponse<StatisticsQueryResultDto>(ResponseType.OK, _service.Search(query));
        }
    }
}