﻿using System;
using System.Collections.Generic;
using Performance.EntityModels;

namespace Performance.DtoModels
{
    public class PerSheetHeader
    {
        // Tuple Items: 列明, 字段名, mergeRow, mergeCell, isTotal, isNumValue, 是否含有%
        public static List<(string, Func<im_employee, object>, int, int, bool, bool, bool, string)> employeeHeaders =
            new List<(string, Func<im_employee, object>, int, int, bool, bool, bool, string)>
            {
                ("人员分类", (t) => t.AccountType, 1, 1, false, false, false,"AccountType"),
                ("核算单元", (t) => t.AccountingUnit, 1, 1, false, false, false,"AccountingUnit"),
                ("人员工号", (t) => t.PersonnelNumber, 1, 1, false, false, false,"PersonnelNumber"),
                ("医生姓名", (t) => t.DoctorName, 1, 1, false, false, false,"DoctorName"),
                ("职务分类", (t) => t.JobTitle, 1, 1, false, true, false,"JobTitle"),
                ("绩效基数核算参考对象", (t) => t.FitPeople, 1, 1, false, false, false, "FitPeople"),
                ("岗位系数", (t) => t.PostCoefficient, 1, 1, false, true, false, "PostCoefficient"),
                //("参加工作时间", (t) => t.WorkTime, 1, 1, false, false, false, "WorkTime"),
                ("考核得分率", (t) => Math.Round((t.ScoreAverageRate ?? 1) * 100, 2) , 1, 1, false, true, true, "ScoreAverageRate"),
                ("出勤率", (t) =>  Math.Round((t.Attendance ?? 0) * 100, 2), 1, 1, false, true, true, "Attendance"),
                //("核算单元医生数", (t) => t.PeopleNumber, 1, 1, false, true, false, "PeopleNumber"),
                //("工作量绩效", (t) =>t.Workload, 1, 1, false, true, false, "Workload"),
                //("其他绩效", (t) => t.OtherPerfor, 1, 1, false, true, false, "OtherPerfor"),
                //("医院奖罚", (t) => t.Punishment, 1, 1, false, true, false, "Punishment"),
                ("调节系数", (t) => Math.Round((t.Adjust ?? 1) * 100, 2), 1, 1, false, true, true, "Adjust"),
                //("发放系数", (t) => t.Grant, 1, 1, false, true, false, "Grant"),
            };

        // Tuple Items: 列明, 字段名, mergeRow, mergeCell, isTotal, isNumValue, 是否含有%
        public static List<(string, Func<im_employee_clinic, object>, int, int, bool, bool, bool, string)> employeeClinicHeaders =
            new List<(string, Func<im_employee_clinic, object>, int, int, bool, bool, bool, string)>
            {
                ("核算单元分类", (t) => t.UnitType, 1, 1, false, false, false, "UnitType"),
                ("核算单元", (t) => t.AccountingUnit, 1, 1, false, false, false, "AccountingUnit"),
                ("人员工号", (t) => t.PersonnelNumber, 1, 1, false, false, false, "PersonnelNumber"),
                ("医生姓名", (t) => t.DoctorName, 1, 1, false, false, false, "DoctorName"),
                ("职务分类", (t) => t.JobTitle, 1, 1, false, true, false, "JobTitle"),
                //("岗位系数", (t) => t.PostCoefficient, 1, 1, false, true, false, "PostCoefficient"),
                ("基础绩效系数", (t) => Math.Round((t.Basics ?? 1) * 100, 2), 1, 1, false, true, false, "Basics"),
                ("效率绩效人数", (t) => t.PermanentStaff, 1, 1, false, true, false, "PermanentStaff"),
                ("效率绩效系数", (t) => Math.Round((t.Efficiency ?? 0) * 100, 2), 1, 1, false, true, true, "Efficiency"),
                ("规模绩效系数", (t) => Math.Round((t.Scale ?? 0) * 100, 2), 1, 1, false, true, true, "Scale"),
                ("管理绩效发放系数", (t) => Math.Round((t.Management ?? 1) * 100, 2), 1, 1, false, true, true, "Management"),
                ("考核得分率", (t) => Math.Round((t.ScoreAverageRate ?? 1) * 100, 2), 1, 1, false, true, true, "ScoreAverageRate"),
                ("出勤率", (t) => Math.Round((t.Attendance ?? 0) * 100, 2), 1, 1, false, true, true, "Attendance"),
                ("其他绩效", (t) => t.OtherPerfor, 1, 1, false, true, false, "OtherPerfor"),
                //("医院奖罚", (t) => t.Punishment, 1, 1, false, true, false, "Punishment"),
                ("调节系数", (t) => Math.Round(t.Adjust.Value * 100, 2), 1, 1, false, true, true, "Adjust"),
            };

        // Tuple Items: 列明, 字段名, mergeRow, mergeCell, isTotal, isNumValue, 是否含有%
        public static List<(string, Func<im_employee_logistics, object>, int, int, bool, bool, bool, string)> employeeLogisticsHeaders =
            new List<(string, Func<im_employee_logistics, object>, int, int, bool, bool, bool, string)>
            {
                ("人员分类", (t) => t.AccountType, 1, 1, false, false, false,"AccountType"),
                ("核算单元", (t) => t.AccountingUnit, 1, 1, false, false, false,"AccountingUnit"),
                ("人员工号", (t) => t.PersonnelNumber, 1, 1, false, false, false,"PersonnelNumber"),
                ("人员姓名", (t) => t.DoctorName, 1, 1, false, false, false,"DoctorName"),
                ("职务分类", (t) => t.JobTitle, 1, 1, false, true, false,"JobTitle"),
                ("绩效基数核算参考对象", (t) => t.FitPeople, 1, 1, false, false, false, "FitPeople"),
                ("岗位系数", (t) => t.PostCoefficient, 1, 1, false, true, false, "PostCoefficient"),
                //("参加工作时间", (t) => t.WorkTime, 1, 1, false, false, false, "WorkTime"),
                //("考核得分率", (t) => Math.Round(t.ScoreAverageRate.Value * 100, 2) , 1, 1, false, true, true, "ScoreAverageRate"),
                ("出勤率", (t) =>  Math.Round((t.Attendance ?? 0) * 100, 2), 1, 1, false, true, true, "Attendance"),
                //("核算单元医生数", (t) => t.PeopleNumber, 1, 1, false, true, false, "PeopleNumber"),
                //("工作量绩效", (t) =>t.Workload, 1, 1, false, true, false, "Workload"),
                ("其他绩效", (t) => t.OtherPerfor, 1, 1, false, true, false, "OtherPerfor"),
                //("医院奖罚", (t) => t.Punishment, 1, 1, false, true, false, "Punishment"),
                //("调节系数", (t) => Math.Round(t.Adjust.Value * 100, 2), 1, 1, false, true, true, "Adjust"),
                //("发放系数", (t) => t.Grant, 1, 1, false, true, false, "Grant"),
            };

        // Tuple Items: 列明, 字段名, mergeRow, mergeCell, isTotal, isNumValue, 是否含有%
        public static List<(string, Func<im_specialunit, object>, int, int, bool, bool, bool, string)> specialUnitHeaders =
             new List<(string, Func<im_specialunit, object>, int, int, bool, bool, bool, string)>
         {
                    ("核算单元", (t) => t.AccountingUnit, 1, 1, false, false, false, "AccountingUnit"),
                    ("科室", (t) => t.Department, 1, 1, false, false, false, "Department"),
                    ("人数", (t) => t.Number, 1, 1, false, true, false, "Number"),
                    ("量化指标", (t) => t.QuantitativeIndicators, 1, 1, false, true, false, "QuantitativeIndicators"),
                    ("数量", (t) => t.Quantity, 1, 1, false, true, false, "Quantity"),
                    ("量化指标绩效分值", (t) => t.QuantitativeIndicatorsValue, 1, 1, false, true, false, "QuantitativeIndicatorsValue"),
                    //("考核得分率", (t) => Math.Round(t.ScoringAverage.Value * 100, 2), 1, 1, false, true, true, "ScoringAverage"),
                    //("其他绩效", (t) => t.OtherPerfor, 1, 1, false, true, false, "OtherPerfor"),
                    //("医院奖罚", (t) => t.Punishment, 1, 1, false, true, false, "Punishment"),
                    //("调节系数", (t) => Math.Round(t.Adjust.Value * 100, 2), 1, 1, false, true, true, "Adjust"),
         };
    }

    public class ColumnHeadsConfig
    {
        public static List<Heads> GatherHeads { get; } = new List<Heads>
        {
            new Heads{Column="来源",Name=nameof(GatherInfoRequest.Source)},
            new Heads{Column="His科室",Name=nameof(GatherInfoRequest.Department)},
            new Heads{Column="医生姓名",Name=nameof(GatherInfoRequest.DoctorName)},
            new Heads{Column="人员工号",Name=nameof(GatherInfoRequest.PersonnelNumber)},
            new Heads{Column="数值类型",Name=nameof(GatherInfoFee.Category)},
            new Heads{Column="数值",Name=nameof(GatherInfoFee.Fee)},
        };

        public static List<Heads> GatherTotal { get; } = new List<Heads>
        {
            //new Heads{Column="His科室",Name=nameof(GatherTotalRequest.Department)},
            new Heads{Column="来源",Name=nameof(GatherTotalRequest.Source)},
            new Heads{Column="核算项目",Name=nameof(GatherTotalRequest.Category)},
            new Heads{Column="提交人",Name=nameof(UserRequest.Login)},
            new Heads{Column="提交日期",Name=nameof(GatherTotalRequest.CreateTime)},
            new Heads{Column="审核日期",Name=nameof(GatherTotalRequest.AuditTime)},
            new Heads{Column="审核状态",Name=nameof(GatherTotalRequest.States)},
            new Heads{Column="失败理由",Name=nameof(GatherTotalRequest.Remark)},
        };
    }

}
