﻿using System.ComponentModel;

namespace Performance.DtoModels
{
    /// <summary>
    /// 菜单条件状态
    /// </summary>
    public enum SelectionState
    {
        /// <summary>
        /// 1 可用并显示
        /// </summary>
        [Description("可用并显示")]
        UsableAndDispaly = 1,
        /// <summary>
        /// 2 可用但不显示
        /// </summary>
        [Description("可用但不显示")]
        UsableAndNotDispaly = 2,
        /// <summary>
        /// 3 不显示不可用
        /// </summary>
        [Description("不显示不可用")]
        NotUsableAndNotDispaly = 3,
        /// <summary>
        /// 4 显示不可用
        /// </summary>
        [Description("显示但不可用")]
        NotUsableAndDispaly = 4
    }
    /// <summary>
    /// 条件加载方式
    /// </summary>
    public enum LoadType
    {
        /// <summary>
        /// 1 立即加载 
        /// </summary>
        InstantLoad = 1,
        /// <summary>
        /// 2 联动加载
        /// </summary> 
        LinkageLoad = 2,
        /// <summary>
        /// 3 自动补全
        /// </summary>
        AutoComplete = 3,
    }

    /// <summary>
    /// SQL操作符
    /// </summary>
    public enum SQLOperator
    {
        /// <summary>
        /// Equal
        /// </summary>
        [Description("Equal")]
        Equal = 1,
        /// <summary>
        /// Like
        /// </summary>
        [Description("Like")]
        Like = 2,
        /// <summary>
        /// In
        /// </summary>
        [Description("In")]
        In = 3,
        /// <summary>
        /// Not Like
        /// </summary>
        [Description("Not Like")]
        NotLike = 4,
        /// <summary>
        /// Not In
        /// </summary>
        [Description("Not In")]
        NotIn = 5,
    }
}
