﻿using System;
using FluentValidation;

namespace Performance.DtoModels
{
    public class AllotRequest
    {
        public int ID { get; set; }

        /// <summary>
        /// 医院ID
        /// </summary>
        public Nullable<int> HospitalId { get; set; }

        /// <summary>
        /// 绩效发放年
        /// </summary>
        public int Year { get; set; }

        /// <summary>
        /// 绩效发放月
        /// </summary>
        public int Month { get; set; }

        /// <summary>
        /// 邮箱
        /// </summary>
        public string Mail { get; set; }

        /// <summary>
        /// 路径
        /// </summary>
        public string Path { get; set; }

        public int isIssued { get; set; }

        public string SearchQuery { get; set; }

        public int? QueryStatus { get; set; }
    }

    public class AllotRequestValidator : AbstractValidator<AllotRequest>
    {
        public AllotRequestValidator()
        {
            RuleSet("Insert", () =>
            {
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                RuleFor(x => x.Year).NotNull().InclusiveBetween(2010, 2055);
                RuleFor(x => x.Month).NotNull().InclusiveBetween(1, 12);
            });

            RuleSet("Update", () =>
            {
                RuleFor(x => x.ID).NotNull().GreaterThan(0);
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
                RuleFor(x => x.Year).NotNull().InclusiveBetween(2010, 2055);
                RuleFor(x => x.Month).NotNull().InclusiveBetween(1, 12);
            });

            RuleSet("Delete", () =>
            {
                RuleFor(x => x.ID).NotNull().GreaterThan(0);
            });

            RuleSet("Template", () =>
            {
                RuleFor(x => x.ID).NotNull().GreaterThan(0);
                RuleFor(x => x.HospitalId).NotNull().GreaterThan(0);
            });
        }
    }
}
