﻿using System;

namespace Performance.DtoModels
{
    public class AllotResponse
    {
        public int ID { get; set; }

        /// <summary>
        /// 医院ID
        /// </summary>
        public int HospitalId { get; set; }

        /// <summary>
        /// 绩效发放年
        /// </summary>
        public int Year { get; set; }

        /// <summary>
        /// 绩效发放月
        /// </summary>
        public int Month { get; set; }

        /// <summary>
        /// 绩效别名
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 绩效发放总金额
        /// </summary>
        public Nullable<decimal> AllotFee { get; set; }

        /// <summary>
        /// 绩效统计时间
        /// </summary>
        public Nullable<DateTime> CreateDate { get; set; }

        /// <summary>
        /// 上传日期
        /// </summary>
        public Nullable<DateTime> UploadDate { get; set; }

        /// <summary>
        /// 0 数据未上传 1 数据已上传 2 正在校验数据 3 数据验证通过 4 数据错误 
        /// 5 正在生成绩效 6 绩效结果解析成功 7 绩效解析失败 8 归档
        /// </summary>
        public int States { get; set; }

        /// <summary>
        /// 科室
        /// </summary>
        public string Department { get; set; }

        /// <summary>
        /// 提取绩效数据文件生成路径
        /// </summary>
        public string ExtractPath { get; set; }

        /// <summary>
        /// 是否可以下载
        /// </summary>
        public bool IsDown { get; set; }

        /// <summary>
        /// 3 提取数据
        /// </summary>
        public int HasConfig { get; set; }

        /// <summary>
        /// 1、人事科提交重新生成
        /// </summary>
        public int Generate { get; set; }

        /// <summary>
        /// 0 不显示 1 显示
        /// </summary>
        public int ShowFormula { get; set; }
    }
}
