﻿using System;

namespace Performance.DtoModels
{
    public class BudgetRatioResponse
    {
        /// <summary>
        /// 医院Id
        /// </summary>
        public int HospitalId { get; set; }

        /// <summary>
        /// 年份
        /// </summary>
        public int Year { get; set; }

        /// <summary>
        /// 人员经费实际比例
        /// </summary>
        public Nullable<decimal> PersonExpendRatio { get; set; }

        /// <summary>
        /// 新绩效实际比例
        /// </summary>
        public Nullable<decimal> NewPerformanceRatio { get; set; }

        /// <summary>
        /// 药占比实际比例
        /// </summary>
        public Nullable<decimal> MedicinePropRatio { get; set; }

        /// <summary>
        /// 材料支出实际比例
        /// </summary>
        public Nullable<decimal> MaterialCostsRatio { get; set; }

        /// <summary>
        /// 药材合计实际比例
        /// </summary>
        public Nullable<decimal> TotalMedicineRatio { get; set; }

        /// <summary>
        /// 固定资产折旧实际比例
        /// </summary>
        public Nullable<decimal> DepreOfFixedAssetsRatio { get; set; }

        /// <summary>
        /// 其他费用实际比例
        /// </summary>
        public Nullable<decimal> OtherExpensesRatio { get; set; }

        /// <summary>
        /// 人+药+材的支出实际比例
        /// </summary>
        public Nullable<decimal> TheCostInTotalRatio { get; set; }

        /// <summary>
        /// 成本合计实际比例
        /// </summary>
        public Nullable<decimal> TheCostCombinedRatio { get; set; }

        /// <summary>
        /// 人员经费（不含绩效）实际比例
        /// </summary>
        public Nullable<decimal> NoPerformanceExpenditureRatio { get; set; }
    }
}
