//-----------------------------------------------------------------------
// <copyright file=" per_apr_amount.cs">
// * FileName: .cs 
// </copyright>
//-----------------------------------------------------------------------
using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels
{
    /// <summary>
    /// 
    /// </summary>
    [Table("per_apr_amount")]
    public class per_apr_amount
    {
        /// <summary>
        /// 
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int AllotId { get; set; }

        /// <summary>
        /// 人员工号
        /// </summary>
        public string PersonnelNumber { get; set; }

        /// <summary>
        /// 医生姓名
        /// </summary>
        public string DoctorName { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string PerforType { get; set; }

        /// <summary>
        /// 金额
        /// </summary>
        public Nullable<decimal> Amount { get; set; }

        /// <summary>
        /// 录入科室
        /// </summary>
        public string TypeInDepartment { get; set; }

        ///// <summary>
        ///// 核算单元
        ///// </summary>
        //public string AccountingUnit { get; set; }

        /// <summary>
        /// 状态 1 未提交  2 等待审核 3 审核通过 4 驳回
        /// </summary>
        public Nullable<int> Status { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public Nullable<DateTime> AuditTime { get; set; }

        /// <summary>
        /// 审核人
        /// </summary>
        public Nullable<int> AuditUser { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public DateTime? CreateDate { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public Nullable<int> CreateUser { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 0 未通过验证 1 通过验证
        /// </summary>
        public int? IsVerify { get; set; }

        /// <summary>
        /// 验证失败描述
        /// </summary>
        public string VerifyMessage { get; set; }
        /// <summary>
        /// 审计状态 1 已审计
        /// </summary>
        public Nullable<int> MarkStatus { get; set; }
        public Nullable<int> MarkUser { get; set; }
        public Nullable<DateTime> MarkTime { get; set; }
    }
}
