﻿using System;
using Microsoft.Extensions.DependencyInjection;

namespace Performance.Infrastructure
{
    public static class InfrastructureExtensions
    {
        /// <summary>
        /// 添加邮件服务
        /// </summary>
        /// <param name="services"></param>
        /// <returns></returns>
        public static IServiceCollection AddEmailUtil(this IServiceCollection services, Action<EmailOptions> configure = null)
        {
            if (configure != null)
            {
                EmailOptions options = new EmailOptions();
                configure.Invoke(options);
                services.AddSingleton(options);
            }
            services.AddSingleton<IEmailService, EmailService>();
            return services;
        }
    }
}
