﻿using System;
using System.Data;
using System.Data.SqlClient;
using MySql.Data.MySqlClient;
using Oracle.ManagedDataAccess.Client;
using Performance.Infrastructure.Helper;

namespace Performance.Repository
{
    /// <summary>
    /// 创建连接
    /// </summary>
    public class ConnectionBuilder
    {
        /// <summary>
        /// 创建连接
        /// </summary>
        /// <param name="type"></param>
        /// <param name="connectionString"></param>
        /// <returns></returns>
        public static IDbConnection Create(DatabaseType type, string connectionString)
        {
            switch (type)
            {
                case DatabaseType.MySql:
                    return new MySqlConnection(connectionString);

                case DatabaseType.SqlServer:
                    return new SqlConnection(connectionString);

                case DatabaseType.Oracle:
                    return new OracleConnection(connectionString);

                default:
                    throw new Exception($"nonsupport {DatabaseType.MySql}");
            }
        }

        /// <summary>
        /// 创建连接字符串
        /// </summary>
        /// <param name="type"></param>
        /// <param name="ip"></param>
        /// <param name="database"></param>
        /// <param name="uid"></param>
        /// <param name="pwd"></param>
        /// <returns></returns>
        public static string GetConnectionString(DatabaseType type, string ip, string database, string uid, string pwd)
        {
            pwd = (AppSQLEncryptConfig.Instance.IsEncryption) ? AESHelper.AESDEncrypt(pwd) : pwd;

            if (type == DatabaseType.MySql)
            {
                string connectionString = string.IsNullOrEmpty(AppSQLEncryptConfig.Instance.TempMySqlConnectionString)
                    ? "Server={0};Database={1};Uid={2};Pwd={3};connection timeout=12000;pooling=true;charset=utf8;Convert Zero Datetime=True;port=3306;Allow User Variables=True;"
                    : AppSQLEncryptConfig.Instance.TempMySqlConnectionString;

                return string.Format(connectionString, ip, database, uid, pwd);
            }
            if (type == DatabaseType.SqlServer)
            {
                string connectionString = string.IsNullOrEmpty(AppSQLEncryptConfig.Instance.TempSqlServerConnectionString)
                        ? "data source={0};initial catalog={1};user id={2};password={3};connection timeout=12000;"
                        : AppSQLEncryptConfig.Instance.TempSqlServerConnectionString;

                return string.Format(connectionString, ip, database, uid, pwd);
            }

            if (type == DatabaseType.Oracle)
            {
                string connectionString = string.IsNullOrEmpty(AppSQLEncryptConfig.Instance.TempOracleConnectionString)
                        ? "Password={3};User ID={2};Connection Timeout=12000;Pooling=true;Data Source=(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST={0})(PORT=1521)))(CONNECT_DATA=(SERVICE_NAME={1})));"
                        : AppSQLEncryptConfig.Instance.TempOracleConnectionString;

                return string.Format(connectionString, ip, database, uid, pwd);
            }

            return "";
        }

        /// <summary>
        /// 创建连接
        /// </summary>
        /// <param name="type"></param>
        /// <param name="ip"></param>
        /// <param name="database"></param>
        /// <param name="uid"></param>
        /// <param name="pwd"></param>
        /// <returns></returns>
        public static IDbConnection Create(DatabaseType type, string ip, string database, string uid, string pwd)
        {
            string connectionString = GetConnectionString(type, ip, database, uid, pwd);
            return Create(type, connectionString);
        }
    }
}